/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateInvalidTypeTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Create Object With Invalid Type Test");
        this.setDescription("Tries to create document with a folder type and folder with a document type.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        Folder testFolder = this.createTestFolder(session);
        try {
            HashMap<String, String> properties;
            block8: {
                try {
                    properties = new HashMap<String, String>();
                    properties.put("cmis:name", "never.txt");
                    properties.put("cmis:objectTypeId", this.getFolderTestTypeId());
                    byte[] contentBytes = IOUtils.toUTF8Bytes((String)"nothing");
                    ContentStreamImpl contentStream = new ContentStreamImpl("never.txt", BigInteger.valueOf(contentBytes.length), "text/plain", (InputStream)new ByteArrayInputStream(contentBytes));
                    testFolder.createDocument(properties, (ContentStream)contentStream, null);
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Creation of a document with a folder type shouldn't work!"));
                }
                catch (Exception e) {
                    if (e instanceof CmisInvalidArgumentException || e instanceof CmisConstraintException) break block8;
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Creation of a document with a folder type threw an unexcpeted exception: " + e.toString()));
                }
            }
            try {
                properties = new HashMap();
                properties.put("cmis:name", "never");
                properties.put("cmis:objectTypeId", this.getDocumentTestTypeId());
                testFolder.createFolder(properties);
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Creation of a folder with a document type shouldn't work!"));
            }
            catch (Exception e) {
                if (!(e instanceof CmisInvalidArgumentException) && !(e instanceof CmisConstraintException)) {
                    this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Creation of a folder with a document type threw an unexcpeted exception: " + e.toString()));
                }
            }
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

