/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.tests.crud;

import java.util.Map;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyTest
extends AbstractSessionTest {
    @Override
    public void init(Map<String, String> parameters) {
        super.init(parameters);
        this.setName("Copy Test");
        this.setDescription("Creates two folders and a document and copies the document from one folder to the other.  If the AtomPub binding is used, this test is skipped.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Session session) {
        try {
            CmisTestResultImpl f;
            Document doc2;
            Folder testFolder = this.createTestFolder(session);
            Folder folder1 = this.createFolder(session, testFolder, "copyfolder1");
            Folder folder2 = this.createFolder(session, testFolder, "copyfolder2");
            Document doc1 = this.createDocument(session, folder1, "copytestdoc.txt", "copy test");
            VersioningState versioningState = VersioningState.MAJOR;
            if (!((DocumentTypeDefinition)doc1.getType()).isVersionable().booleanValue()) {
                versioningState = VersioningState.NONE;
            }
            if ((doc2 = doc1.copy((ObjectId)folder2, null, versioningState, null, null, null, SELECT_ALL_NO_CACHE_OC)) == null) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Copied document is null!"));
            } else {
                this.addResult(this.checkObject(session, (CmisObject)doc2, this.getAllProperties((CmisObject)doc2), "Copied document check. Id: + " + doc2.getName()));
                f = this.createResult(CmisTestResultStatus.FAILURE, "Content streams don't match!");
                this.addResult(this.assertEquals(doc1.getContentStream(), doc2.getContentStream(), (CmisTestResult)null, (CmisTestResult)f));
            }
            int count1 = this.countFolderChildren(folder1);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Source folder should have exactly one child but has " + count1 + " children!");
            this.addResult(this.assertEquals(1, count1, null, (CmisTestResult)f));
            int count2 = this.countFolderChildren(folder2);
            f = this.createResult(CmisTestResultStatus.FAILURE, "Target folder should have exactly one child but has " + count2 + " children!");
            this.addResult(this.assertEquals(1, count2, null, (CmisTestResult)f));
            this.deleteObject((CmisObject)doc2);
            this.deleteObject((CmisObject)doc1);
        }
        finally {
            this.deleteTestFolder();
        }
    }
}

