/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.tck.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Item;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.Relationship;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.SessionFactory;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.NewTypeSettableAttributes;
import org.apache.chemistry.opencmis.commons.data.RepositoryCapabilities;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.CapabilityOrderBy;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisBaseException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.IOUtils;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.chemistry.opencmis.tck.CmisTestResult;
import org.apache.chemistry.opencmis.tck.CmisTestResultStatus;
import org.apache.chemistry.opencmis.tck.impl.AbstractCmisTest;
import org.apache.chemistry.opencmis.tck.impl.CmisTestResultImpl;
import org.apache.chemistry.opencmis.tck.impl.FatalTestException;
import org.apache.chemistry.opencmis.tck.impl.PropertyCheckEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSessionTest
extends AbstractCmisTest {
    public static final OperationContext SELECT_ALL_NO_CACHE_OC = new OperationContextImpl();
    public static final OperationContext SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME;
    private final SessionFactory factory = SessionFactoryImpl.newInstance();
    private Folder testFolder;
    private Boolean supportsRelationships;
    private Boolean supportsPolicies;
    private Boolean supportsItems;
    private Boolean supportsSecondaries;

    public BindingType getBinding() {
        if (this.getParameters() == null) {
            return null;
        }
        try {
            return BindingType.fromValue((String)this.getParameters().get("org.apache.chemistry.opencmis.binding.spi.type"));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return super.getName() + " (" + this.getBinding() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        Map<String, String> parameters = this.getParameters();
        String repId = parameters.get("org.apache.chemistry.opencmis.session.repository.id");
        Session session = repId != null && repId.length() > 0 ? this.factory.createSession(parameters) : ((Repository)this.factory.getRepositories(parameters).get(0)).createSession();
        session.getDefaultContext().setCacheEnabled(false);
        try {
            this.run(session);
        }
        catch (Exception e) {
            if (!(e instanceof FatalTestException)) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Exception: " + e, e, true));
            }
        }
        catch (Error err) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Error: " + err, err, true));
        }
        finally {
            this.testFolder = null;
        }
    }

    public abstract void run(Session var1) throws Exception;

    protected RepositoryInfo getRepositoryInfo(Session session) {
        RepositoryInfo ri = session.getRepositoryInfo();
        CmisTestResultImpl failure = this.createResult(CmisTestResultStatus.FAILURE, "Repository info is null!", true);
        this.addResult(this.assertNotNull(ri, null, failure));
        return ri;
    }

    protected String getFolderTestTypeId() {
        String objectTypeId = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.folderType");
        if (objectTypeId == null) {
            objectTypeId = "cmis:folder";
        }
        return objectTypeId;
    }

    protected String getDocumentTestTypeId() {
        String objectTypeId = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.documentType");
        if (objectTypeId == null) {
            objectTypeId = "cmis:document";
        }
        return objectTypeId;
    }

    protected String getItemTestTypeId() {
        String objectTypeId = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.itemType");
        if (objectTypeId == null) {
            objectTypeId = "cmis:item";
        }
        return objectTypeId;
    }

    protected String getSecondaryTestTypeId() {
        String objectTypeId = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.secondaryType");
        if (objectTypeId == null) {
            objectTypeId = "cmis:secondary";
        }
        return objectTypeId;
    }

    protected String[] getAllProperties(CmisObject object) {
        String[] propertiesk = new String[object.getType().getPropertyDefinitions().size()];
        int i = 0;
        for (String propId : object.getType().getPropertyDefinitions().keySet()) {
            propertiesk[i++] = propId;
        }
        return propertiesk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getStringFromContentStream(ContentStream contentStream) throws IOException {
        if (contentStream == null || contentStream.getStream() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(contentStream.getStream(), "UTF-8");
        try {
            char[] buffer = new char[65536];
            while (true) {
                int b;
                if ((b = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                    sb.append(buffer, 0, b);
                    continue;
                }
                if (b == -1) break;
            }
        }
        finally {
            ((Reader)reader).close();
        }
        return sb.toString();
    }

    protected Folder createFolder(Session session, Folder parent, String name) {
        return this.createFolder(session, parent, name, this.getFolderTestTypeId());
    }

    protected Folder createFolder(Session session, Folder parent, String name, String objectTypeId) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent is not set!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is not set!");
        }
        if (objectTypeId == null) {
            throw new IllegalArgumentException("Object Type Id is not set!");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", objectTypeId);
        Folder result = null;
        try {
            result = parent.createFolder(properties, null, null, null, SELECT_ALL_NO_CACHE_OC);
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Folder could not be created! Exception: " + e.getMessage(), e, true));
            return null;
        }
        try {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Folder name does not match!", false);
            this.addResult(this.assertEquals(name, result.getName(), null, (CmisTestResult)f));
            String[] propertiesToCheck = new String[result.getType().getPropertyDefinitions().size()];
            int i = 0;
            for (String propId : result.getType().getPropertyDefinitions().keySet()) {
                propertiesToCheck[i++] = propId;
            }
            this.addResult(this.checkObject(session, (CmisObject)result, propertiesToCheck, "New folder object spec compliance"));
            List objectParents = result.getParents();
            f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created folder has no or more than one parent! Id: " + result.getId(), true);
            this.addResult(this.assertEquals(1, objectParents.size(), null, (CmisTestResult)f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "First object parent of the newly created folder does not match parent! Id: " + result.getId(), true);
            this.assertShallowEquals((CmisObject)parent, (CmisObject)objectParents.get(0), null, f);
            Folder folderParent = result.getFolderParent();
            f = this.createResult(CmisTestResultStatus.FAILURE, "Newly created folder has no folder parent! Id: " + result.getId(), true);
            this.addResult(this.assertNotNull(folderParent, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Folder parent of the newly created folder does not match parent! Id: " + result.getId(), true);
            this.assertShallowEquals((CmisObject)parent, (CmisObject)folderParent, null, f);
            boolean found = false;
            for (CmisObject child : parent.getChildren(SELECT_ALL_NO_CACHE_OC)) {
                if (child == null) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Parent folder contains a null child!", true));
                    continue;
                }
                if (!result.getId().equals(child.getId())) continue;
                found = true;
                f = this.createResult(CmisTestResultStatus.FAILURE, "Folder and parent child don't match! Id: " + result.getId(), true);
                this.assertShallowEquals((CmisObject)result, child, null, f);
                break;
            }
            if (!found) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Folder is not a child of the parent folder! Id: " + result.getId(), true));
            }
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Newly created folder is invalid! Exception: " + e.getMessage(), e, true));
        }
        return result;
    }

    protected int countFolderChildren(Folder folder) {
        int count = 0;
        for (CmisObject object : folder.getChildren()) {
            ++count;
        }
        return count;
    }

    protected Document createDocument(Session session, Folder parent, String name, String content) {
        return this.createDocument(session, parent, name, this.getDocumentTestTypeId(), null, content);
    }

    protected Document createDocument(Session session, Folder parent, String name, String objectTypeId, String[] secondaryTypeIds, String content) {
        ObjectType type;
        if (parent == null) {
            throw new IllegalArgumentException("Parent is not set!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is not set!");
        }
        if (objectTypeId == null) {
            throw new IllegalArgumentException("Object Type Id is not set!");
        }
        if (content == null) {
            content = "";
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", objectTypeId);
        if (secondaryTypeIds != null) {
            properties.put("cmis:secondaryObjectTypeIds", Arrays.asList(secondaryTypeIds));
        }
        if (!((type = session.getTypeDefinition(objectTypeId)) instanceof DocumentTypeDefinition)) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Type is not a document type! Type: " + objectTypeId, true));
            return null;
        }
        DocumentTypeDefinition docType = (DocumentTypeDefinition)type;
        VersioningState versioningState = Boolean.TRUE.equals(docType.isVersionable()) ? VersioningState.MAJOR : VersioningState.NONE;
        byte[] contentBytes = null;
        Document result = null;
        try {
            contentBytes = IOUtils.toUTF8Bytes((String)content);
            ContentStreamImpl contentStream = new ContentStreamImpl(name, BigInteger.valueOf(contentBytes.length), "text/plain", (InputStream)new ByteArrayInputStream(contentBytes));
            result = parent.createDocument(properties, (ContentStream)contentStream, versioningState, null, null, null, SELECT_ALL_NO_CACHE_OC);
            contentStream.getStream().close();
        }
        catch (Exception e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Document could not be created! Exception: " + e.getMessage(), e, true));
            return null;
        }
        try {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Document name does not match!", false);
            this.addResult(this.assertEquals(name, result.getName(), null, (CmisTestResult)f));
            this.addResult(this.checkObject(session, (CmisObject)result, this.getAllProperties((CmisObject)result), "New document object spec compliance"));
            try {
                ContentStream contentStream = result.getContentStream();
                f = this.createResult(CmisTestResultStatus.WARNING, "Document filename does not match!", false);
                this.addResult(this.assertEquals(name, contentStream.getFileName(), null, (CmisTestResult)f));
                f = this.createResult(CmisTestResultStatus.WARNING, "cmis:contentStreamFileName and the filename of the content stream do not match!", false);
                this.addResult(this.assertEquals(result.getContentStreamFileName(), contentStream.getFileName(), null, (CmisTestResult)f));
                String fetchedContent = this.getStringFromContentStream(result.getContentStream());
                if (!content.equals(fetchedContent)) {
                    this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Content of newly created document doesn't match the orign content!"));
                }
            }
            catch (IOException e) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Content of newly created document couldn't be read! Exception: " + e.getMessage(), e, true));
            }
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Newly created document is invalid! Exception: " + e.getMessage(), e, true));
        }
        List parents = result.getParents(SELECT_ALL_NO_CACHE_OC);
        boolean found = false;
        for (Folder folder : parents) {
            if (!parent.getId().equals(folder.getId())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "The folder the document has been created in is not in the list of the document parents!"));
        }
        return result;
    }

    protected Relationship createRelationship(Session session, String name, ObjectId source, ObjectId target) {
        String objectTypeId = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.relationshipType");
        if (objectTypeId == null) {
            objectTypeId = "cmis:relationship";
        }
        return this.createRelationship(session, name, source, target, objectTypeId);
    }

    protected Relationship createRelationship(Session session, String name, ObjectId source, ObjectId target, String objectTypeId) {
        if (name == null) {
            throw new IllegalArgumentException("Name is not set!");
        }
        if (objectTypeId == null) {
            throw new IllegalArgumentException("Object Type Id is not set!");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", objectTypeId);
        properties.put("cmis:sourceId", source.getId());
        properties.put("cmis:targetId", target.getId());
        Relationship result = null;
        try {
            ObjectId relId = session.createRelationship(properties);
            result = (Relationship)session.getObject(relId, SELECT_ALL_NO_CACHE_OC);
        }
        catch (Exception e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Relationship could not be created! Exception: " + e.getMessage(), e, true));
        }
        if (result != null) {
            try {
                this.addResult(this.checkObject(session, (CmisObject)result, this.getAllProperties((CmisObject)result), "New document object spec compliance"));
            }
            catch (CmisBaseException e) {
                this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Newly created document is invalid! Exception: " + e.getMessage(), e, true));
            }
        }
        return result;
    }

    protected Item createItem(Session session, Folder parent, String name) {
        return this.createItem(session, parent, name, this.getItemTestTypeId());
    }

    protected Item createItem(Session session, Folder parent, String name, String objectTypeId) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent is not set!");
        }
        if (name == null) {
            throw new IllegalArgumentException("Name is not set!");
        }
        if (objectTypeId == null) {
            throw new IllegalArgumentException("Object Type Id is not set!");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cmis:name", name);
        properties.put("cmis:objectTypeId", objectTypeId);
        Item result = null;
        try {
            result = parent.createItem(properties, null, null, null, SELECT_ALL_NO_CACHE_OC);
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Item could not be created! Exception: " + e.getMessage(), e, true));
            return null;
        }
        try {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Item name does not match!", false);
            this.addResult(this.assertEquals(name, result.getName(), null, (CmisTestResult)f));
            this.addResult(this.checkObject(session, (CmisObject)result, this.getAllProperties((CmisObject)result), "New item object spec compliance"));
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Newly created Item is invalid! Exception: " + e.getMessage(), e, true));
        }
        List parents = result.getParents(SELECT_ALL_NO_CACHE_OC);
        boolean found = false;
        for (Folder folder : parents) {
            if (!parent.getId().equals(folder.getId())) continue;
            found = true;
            break;
        }
        if (!found) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "The folder the item has been created in is not in the list of the item parents!"));
        }
        return result;
    }

    protected void deleteObject(CmisObject object) {
        if (object != null) {
            if (object instanceof Folder) {
                try {
                    ((Folder)object).deleteTree(true, null, true);
                }
                catch (CmisBaseException e) {
                    this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Folder could not be deleted! Exception: " + e.getMessage(), e, true));
                }
            } else {
                try {
                    object.delete(true);
                }
                catch (CmisBaseException e) {
                    this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Object could not be deleted! Exception: " + e.getMessage(), e, true));
                }
            }
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Object should not exist anymore but it is still there! Id: " + object.getId(), true);
            this.addResult(this.assertIsFalse(this.exists(object), null, f));
        }
    }

    protected boolean exists(CmisObject object) {
        try {
            object.refresh();
            return true;
        }
        catch (CmisObjectNotFoundException e) {
            return false;
        }
    }

    protected ObjectType createType(Session session, TypeDefinition typeDef) {
        NewTypeSettableAttributes settableAttributes = session.getRepositoryInfo().getCapabilities().getNewTypeSettableAttributes();
        if (settableAttributes == null) {
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Repository Info does not indicate, which type attributes can be set!"));
        }
        ObjectType newType = null;
        try {
            newType = session.createType(typeDef);
            this.addResult(this.createInfoResult("Created type '" + typeDef.getId() + "'. Repository assigned the following type id: " + newType.getId()));
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Creating type '" + typeDef.getId() + "' failed: " + e.getMessage(), e, false));
            return null;
        }
        this.addResult(this.checkTypeDefinition(session, (TypeDefinition)newType, "Newly created type spec compliance."));
        if (newType.getTypeMutability() == null) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Newly created type does not provide type mutability data! Id: " + newType.getId()));
        }
        return newType;
    }

    protected void deleteType(Session session, String typeId) {
        ObjectType type = session.getTypeDefinition(typeId);
        if (type == null) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Type does not exist and therefore cannot be deleted! Id: " + typeId));
            return;
        }
        if (type.getTypeMutability() == null) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Type does not provide type mutability data! Id: " + typeId));
        } else if (!Boolean.TRUE.equals(type.getTypeMutability().canDelete())) {
            this.addResult(this.createResult(CmisTestResultStatus.WARNING, "Type indicates that it cannot be deleted. Trying it anyway. Id: " + typeId));
        }
        try {
            session.deleteType(typeId);
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Deleting type '" + typeId + "' failed: " + e.getMessage(), e, false));
            return;
        }
        try {
            session.getTypeDefinition(typeId);
            this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Type should not exist anymore but it is still there! Id: " + typeId, true));
        }
        catch (CmisObjectNotFoundException e) {
            // empty catch block
        }
    }

    protected Folder createTestFolder(Session session) {
        String testFolderParentPath = this.getParameters().get("org.apache.chemistry.opencmis.tck.default.testFolderParent");
        if (testFolderParentPath == null) {
            testFolderParentPath = "/";
        }
        String name = "cmistck" + System.currentTimeMillis() + session.getRepositoryInfo().hashCode();
        Folder parent = null;
        try {
            CmisObject parentObject = session.getObjectByPath(testFolderParentPath, SELECT_ALL_NO_CACHE_OC);
            if (!(parentObject instanceof Folder)) {
                this.addResult(this.createResult(CmisTestResultStatus.FAILURE, "Parent folder of the test folder is actually not a folder! Path: " + testFolderParentPath, true));
            }
            parent = (Folder)parentObject;
        }
        catch (CmisBaseException e) {
            this.addResult(this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, "Test folder could not be created! Exception: " + e.getMessage(), e, true));
        }
        if (parent != null) {
            this.testFolder = this.createFolder(session, parent, name);
        }
        return this.testFolder;
    }

    protected Folder getTestFolder() {
        return this.testFolder;
    }

    protected void deleteTestFolder() {
        this.deleteObject((CmisObject)this.testFolder);
    }

    protected boolean isGetDescendantsSupported(Session session) {
        RepositoryCapabilities cap = session.getRepositoryInfo().getCapabilities();
        if (cap == null) {
            return false;
        }
        if (cap.isGetDescendantsSupported() == null) {
            return false;
        }
        return cap.isGetDescendantsSupported();
    }

    protected boolean isGetFolderTreeSupported(Session session) {
        RepositoryCapabilities cap = session.getRepositoryInfo().getCapabilities();
        if (cap == null) {
            return false;
        }
        if (cap.isGetFolderTreeSupported() == null) {
            return false;
        }
        return cap.isGetFolderTreeSupported();
    }

    protected boolean isOrderByNameSupported(Session session) {
        return session.getRepositoryInfo().getCapabilities().getOrderByCapability() != CapabilityOrderBy.NONE;
    }

    protected boolean hasRelationships(Session session) {
        if (this.supportsRelationships == null) {
            this.supportsRelationships = Boolean.FALSE;
            for (ObjectType type : session.getTypeChildren(null, false)) {
                if (!BaseTypeId.CMIS_RELATIONSHIP.value().equals(type.getId())) continue;
                this.supportsRelationships = Boolean.TRUE;
                break;
            }
        }
        return this.supportsRelationships;
    }

    protected boolean hasPolicies(Session session) {
        if (this.supportsPolicies == null) {
            this.supportsPolicies = Boolean.FALSE;
            for (ObjectType type : session.getTypeChildren(null, false)) {
                if (!BaseTypeId.CMIS_POLICY.value().equals(type.getId())) continue;
                this.supportsPolicies = Boolean.TRUE;
                break;
            }
        }
        return this.supportsPolicies;
    }

    protected boolean hasItems(Session session) {
        if (this.supportsItems == null) {
            this.supportsItems = Boolean.FALSE;
            for (ObjectType type : session.getTypeChildren(null, false)) {
                if (!BaseTypeId.CMIS_ITEM.value().equals(type.getId())) continue;
                this.supportsItems = Boolean.TRUE;
                break;
            }
        }
        return this.supportsItems;
    }

    protected boolean hasSecondaries(Session session) {
        if (this.supportsSecondaries == null) {
            this.supportsSecondaries = Boolean.FALSE;
            for (ObjectType type : session.getTypeChildren(null, false)) {
                if (!BaseTypeId.CMIS_SECONDARY.value().equals(type.getId())) continue;
                this.supportsSecondaries = Boolean.TRUE;
                break;
            }
        }
        return this.supportsSecondaries;
    }

    protected CmisTestResult checkObject(Session session, CmisObject object, String[] properties, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Object is null!", true);
        this.addResult(results, this.assertNotNull(object, null, f));
        if (object != null) {
            List otids;
            f = this.createResult(CmisTestResultStatus.FAILURE, "Object id is not set!");
            this.addResult(results, this.assertStringNotEmpty(object.getId(), null, f));
            Calendar creationDate = null;
            Calendar lastModificationDate = null;
            for (String propId : properties) {
                Property prop = object.getProperty(propId);
                PropertyCheckEnum propertyCheck = PropertyCheckEnum.NO_VALUE_CHECK;
                if ("cmis:objectId".equals(propId) || "cmis:baseTypeId".equals(propId) || "cmis:objectTypeId".equals(propId) || "cmis:path".equals(propId) || "cmis:sourceId".equals(propId) || "cmis:targetId".equals(propId)) {
                    propertyCheck = PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY;
                }
                if (!(object instanceof Relationship) && ("cmis:createdBy".equals(propId) || "cmis:lastModifiedBy".equals(propId))) {
                    propertyCheck = PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY;
                }
                if ("cmis:name".equals(propId) || "cmis:policyText".equals(propId)) {
                    propertyCheck = PropertyCheckEnum.STRING_SHOULD_NOT_BE_EMPTY;
                }
                if ("cmis:isImmutable".equals(propId)) {
                    propertyCheck = PropertyCheckEnum.MUST_BE_SET;
                }
                if (!(object instanceof Relationship) && ("cmis:creationDate".equals(propId) || "cmis:lastModificationDate".equals(propId))) {
                    propertyCheck = PropertyCheckEnum.MUST_BE_SET;
                }
                if ("cmis:parentId".equals(propId)) {
                    if (object instanceof Folder) {
                        propertyCheck = ((Folder)object).isRootFolder() ? PropertyCheckEnum.MUST_NOT_BE_SET : PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY;
                    } else {
                        this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Property cmis:parentId is only defined for folders!"));
                    }
                }
                if ("cmis:path".equals(propId) && prop.getFirstValue() != null) {
                    Object path = prop.getFirstValue();
                    if (path instanceof String) {
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Path does not start with '/': " + path);
                        this.addResult(results, this.assertIsTrue(((String)path).length() > 0 && ((String)path).charAt(0) == '/', null, f));
                    } else {
                        this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Property cmis:path is not a string!"));
                    }
                }
                this.addResult(results, this.checkProperty(prop, "Property " + propId, propertyCheck));
                if ("cmis:creationDate".equals(propId)) {
                    creationDate = (GregorianCalendar)prop.getFirstValue();
                    continue;
                }
                if (!"cmis:lastModificationDate".equals(propId)) continue;
                lastModificationDate = (GregorianCalendar)prop.getFirstValue();
            }
            if (creationDate != null && lastModificationDate != null) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Last modification date precedes creation date!");
                this.addResult(results, this.assertIsTrue(creationDate.getTimeInMillis() <= lastModificationDate.getTimeInMillis(), null, f));
            }
            if (object.getAllowableActions() == null || object.getAllowableActions().getAllowableActions() == null) {
                this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Object has no allowable actions!"));
            } else {
                AllowableActions allowableActions;
                Set actions = object.getAllowableActions().getAllowableActions();
                f = this.createResult(CmisTestResultStatus.FAILURE, "Object has no CAN_GET_PROPERTIES allowable action!");
                this.addResult(results, this.assertAllowableAction(object, Action.CAN_GET_PROPERTIES, null, f));
                if (object instanceof Document) {
                    if (actions.contains(Action.CAN_CHECK_OUT) && actions.contains(Action.CAN_CHECK_IN)) {
                        this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Document object has CAN_CHECK_OUT and CAN_CHECK_IN allowable actions!"));
                    }
                    if (actions.contains(Action.CAN_CHECK_OUT) && actions.contains(Action.CAN_CANCEL_CHECK_OUT)) {
                        this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Document object has CAN_CHECK_OUT and CAN_CANCEL_CHECK_OUT allowable actions!"));
                    }
                    Document doc = (Document)object;
                    DocumentTypeDefinition docType = (DocumentTypeDefinition)doc.getType();
                    if (doc.isVersionSeriesCheckedOut() != null) {
                        if (doc.isVersionSeriesCheckedOut().booleanValue()) {
                            f = this.createResult(CmisTestResultStatus.WARNING, "Document is checked out and has CAN_CHECK_OUT allowable action!");
                            this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CHECK_OUT, null, f));
                            if (doc.getVersionSeriesCheckedOutId() == null) {
                                this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Document is checked out and but the property cmis:versionSeriesCheckedOutId is not set!"));
                            } else if (doc.getVersionSeriesCheckedOutId().equals(object.getId())) {
                                f = this.createResult(CmisTestResultStatus.FAILURE, "PWC doesn't have CAN_CHECK_IN allowable action!");
                                this.addResult(results, this.assertAllowableAction(object, Action.CAN_CHECK_IN, null, f));
                                f = this.createResult(CmisTestResultStatus.FAILURE, "PWC doesn't have CAN_CANCEL_CHECK_OUT allowable action!");
                                this.addResult(results, this.assertAllowableAction(object, Action.CAN_CANCEL_CHECK_OUT, null, f));
                            } else {
                                f = this.createResult(CmisTestResultStatus.WARNING, "Non-PWC has CAN_CHECK_IN allowable action!");
                                this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CHECK_IN, null, f));
                                f = this.createResult(CmisTestResultStatus.WARNING, "Non-PWC has CAN_CANCEL_CHECK_OUT allowable action!");
                                this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CANCEL_CHECK_OUT, null, f));
                            }
                        } else {
                            f = this.createResult(CmisTestResultStatus.FAILURE, "Document is not checked out and has CAN_CHECK_IN allowable action!");
                            this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CHECK_IN, null, f));
                            f = this.createResult(CmisTestResultStatus.FAILURE, "Document is not checked out and has CAN_CANCEL_CHECK_OUT allowable action!");
                            this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CANCEL_CHECK_OUT, null, f));
                            if (docType.isVersionable().booleanValue()) {
                                if (Boolean.TRUE.equals(doc.isLatestVersion())) {
                                    f = this.createResult(CmisTestResultStatus.WARNING, "Document is versionable and not checked but has no CAN_CHECK_OUT allowable action!");
                                    this.addResult(results, this.assertAllowableAction(object, Action.CAN_CHECK_OUT, null, f));
                                }
                            } else {
                                f = this.createResult(CmisTestResultStatus.FAILURE, "Document is not versionable but has CAN_CHECK_OUT allowable action!");
                                this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CHECK_OUT, null, f));
                            }
                        }
                    } else {
                        this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Property cmis:isVersionSeriesCheckedOut is not set!"));
                    }
                    if (Boolean.TRUE.equals(doc.isImmutable())) {
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Document is immutable and has CAN_UPDATE_PROPERTIES allowable action!");
                        this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_UPDATE_PROPERTIES, null, f));
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Document is immutable and has CAN_DELETE_OBJECT allowable action!");
                        this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_DELETE_OBJECT, null, f));
                    }
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Document object has CAN_CHECK_IN allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CHECK_IN, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Document object has CAN_CHECK_OUT allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CHECK_OUT, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Document object has CAN_CANCEL_CHECK_OUT allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CANCEL_CHECK_OUT, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Document object has CAN_GET_CONTENT_STREAM allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_GET_CONTENT_STREAM, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Document object has CAN_DELETE_CONTENT_STREAM allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_DELETE_CONTENT_STREAM, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Document object has CAN_GET_ALL_VERSIONS allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_GET_ALL_VERSIONS, null, f));
                }
                if (object instanceof Folder) {
                    Folder folder = (Folder)object;
                    if (folder.isRootFolder()) {
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Root folder has CAN_DELETE_OBJECT allowable action!");
                        this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_DELETE_OBJECT, null, f));
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Root folder has CAN_GET_FOLDER_PARENT allowable action!");
                        this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_GET_FOLDER_PARENT, null, f));
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Root folder has CAN_MOVE_OBJECT allowable action!");
                        this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_MOVE_OBJECT, null, f));
                    }
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Folder object has CAN_GET_DESCENDANTS allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_GET_DESCENDANTS, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Folder object has CAN_GET_FOLDER_PARENT allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_GET_FOLDER_PARENT, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Folder object has CAN_GET_CHILDREN allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_GET_CHILDREN, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Folder object has CAN_DELETE_TREE allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_DELETE_TREE, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Folder object has CAN_GET_FOLDER_PARENT allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_GET_FOLDER_PARENT, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Folder object has CAN_CREATE_DOCUMENT allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CREATE_DOCUMENT, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Folder object has CAN_CREATE_FOLDER allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_CREATE_FOLDER, null, f));
                }
                if (!(object instanceof FileableCmisObject) || object instanceof Folder) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Filable object or folder has CAN_ADD_OBJECT_TO_FOLDER allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_ADD_OBJECT_TO_FOLDER, null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Filable object or folder has CAN_REMOVE_OBJECT_FROM_FOLDER allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_REMOVE_OBJECT_FROM_FOLDER, null, f));
                }
                if (!(object instanceof FileableCmisObject)) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Non-Fileable object has CAN_MOVE_OBJECT allowable action!");
                    this.addResult(results, this.assertNotAllowableAction(object, Action.CAN_MOVE_OBJECT, null, f));
                }
                if ((allowableActions = session.getBinding().getObjectService().getAllowableActions(session.getRepositoryInfo().getId(), object.getId(), null)).getAllowableActions() == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "getAllowableActions() didn't returned allowable actions!"));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Object allowable actions don't match the allowable actions returned by getAllowableActions()!");
                    this.addResult(results, this.assertEqualSet(object.getAllowableActions().getAllowableActions(), allowableActions.getAllowableActions(), null, f));
                }
            }
            if (object.getAcl() != null && object.getAcl().getAces() != null) {
                this.addResult(results, this.checkACL(session, object.getAcl(), "ACL"));
            }
            if (this.hasPolicies(session)) {
                try {
                    List objectPolicies;
                    List appliedPolicies = session.getBinding().getPolicyService().getAppliedPolicies(session.getRepositoryInfo().getId(), object.getId(), "*", null);
                    if (appliedPolicies == null) {
                        appliedPolicies = Collections.emptyList();
                    }
                    if ((objectPolicies = object.getPolicies()) == null) {
                        objectPolicies = Collections.emptyList();
                    }
                    f = this.createResult(CmisTestResultStatus.FAILURE, "The number of policies returned by getAppliedPolicies() and the number of object policies don't match!");
                    this.addResult(results, this.assertEquals(appliedPolicies.size(), objectPolicies.size(), null, (CmisTestResult)f));
                }
                catch (CmisNotSupportedException e) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "getAppliedPolicies() not supported for object: " + object.getId()));
                }
            }
            this.checkRelationships(session, results, object);
            this.checkDocumentContent(session, results, object);
            if (object.getRenditions() != null) {
                this.addResult(results, this.checkRenditions(session, object, "Rendition check"));
            }
            if (object instanceof Folder && (otids = (List)object.getPropertyValue("cmis:allowedChildObjectTypeIds")) != null) {
                for (String otid : otids) {
                    try {
                        session.getTypeDefinition(otid);
                    }
                    catch (CmisBaseException e) {
                        this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "The cmis:allowedChildObjectTypeIds property contains the type id '" + otid + "' but the type doesn't exists. Folder id: " + object.getId()));
                    }
                }
            }
            if (object instanceof FileableCmisObject) {
                List paths = ((FileableCmisObject)object).getPaths();
                if (object instanceof Folder) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Folder does not have excatly one path! This is an OpenCMIS bug!");
                    this.addResult(results, this.assertEquals(1, paths.size(), null, (CmisTestResult)f));
                } else if (Boolean.FALSE.equals(session.getRepositoryInfo().getCapabilities().isMultifilingSupported())) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Repository does not support multi-filing, but the object has more than one parent!");
                    this.addResult(results, this.assertIsTrue(paths.size() < 2, null, f));
                }
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult checkACL(Session session, Acl acl, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "ACL is null!");
        this.addResult(results, this.assertNotNull(acl, null, f));
        if (acl != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "List of ACEs is null!");
            this.addResult(results, this.assertNotNull(acl.getAces(), null, f));
            if (acl.getAces() != null) {
                for (Ace ace : acl.getAces()) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "ACE with empty principal id!");
                    this.addResult(results, this.assertStringNotEmpty(ace.getPrincipalId(), null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "ACE with empty permission list!");
                    this.addResult(results, this.assertListNotEmpty(ace.getPermissions(), null, f));
                    if (ace.getPermissions() == null) continue;
                    for (String permission : ace.getPermissions()) {
                        f = this.createResult(CmisTestResultStatus.FAILURE, "ACE with empty permission entry!");
                        this.addResult(results, this.assertStringNotEmpty(permission, null, f));
                    }
                }
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    private void checkRelationships(Session session, List<CmisTestResult> results, CmisObject object) {
        if (object instanceof Relationship && object.getRelationships() != null && !object.getRelationships().isEmpty()) {
            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "A relationship has relationships!"));
            return;
        }
        if (object.getRelationships() != null) {
            for (Relationship relationship : object.getRelationships()) {
                if (relationship == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "A relationship in the relationship list is null!"));
                    continue;
                }
                CmisObject fullRelationshipObject = session.getObject((ObjectId)relationship, SELECT_ALL_NO_CACHE_OC);
                this.addResult(results, this.checkObject(session, fullRelationshipObject, this.getAllProperties(fullRelationshipObject), "Relationship check: " + fullRelationshipObject.getId()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDocumentContent(Session session, List<CmisTestResult> results, CmisObject object) {
        InputStream stream;
        String contentMimeType;
        String docMimeType;
        ContentStream contentStream;
        boolean hasContentProperties;
        if (!(object instanceof Document)) {
            return;
        }
        Document doc = (Document)object;
        DocumentTypeDefinition type = (DocumentTypeDefinition)doc.getType();
        boolean bl = hasContentProperties = doc.getContentStreamFileName() != null || doc.getContentStreamId() != null || doc.getContentStreamLength() > -1L || doc.getContentStreamMimeType() != null;
        if (hasContentProperties) {
            if (type.getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED) {
                this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Content properties have values but the document type doesn't allow content!"));
            }
        } else if (type.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Content properties are not set but the document type demands content!"));
        }
        if ((contentStream = doc.getContentStream()) == null) {
            if (hasContentProperties && doc.getContentStreamLength() > 0L) {
                this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Content properties have values but the document has no content!"));
            }
            if (type.getContentStreamAllowed() == ContentStreamAllowed.REQUIRED) {
                this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "The document type demands content but the document has no content!"));
            }
            return;
        }
        if (type.getContentStreamAllowed() == ContentStreamAllowed.NOTALLOWED) {
            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Document type doesn't allow content but document has content!"));
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Content file names don't match!");
        this.addResult(results, this.assertEquals(doc.getContentStreamFileName(), contentStream.getFileName(), null, (CmisTestResult)f));
        if (doc.getContentStreamLength() > -1L && contentStream.getLength() > -1L) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Content lengths don't match!");
            this.addResult(results, this.assertEquals(doc.getContentStreamLength(), contentStream.getLength(), null, (CmisTestResult)f));
        }
        if ((docMimeType = doc.getContentStreamMimeType()) != null) {
            int x = docMimeType.indexOf(59);
            if (x > -1) {
                docMimeType = docMimeType.substring(0, x);
            }
            docMimeType = docMimeType.trim();
        }
        if ((contentMimeType = contentStream.getMimeType()) != null) {
            int x = contentMimeType.indexOf(59);
            if (x > -1) {
                contentMimeType = contentMimeType.substring(0, x);
            }
            contentMimeType = contentMimeType.trim();
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "Content MIME types don't match!");
        this.addResult(results, this.assertEquals(docMimeType, contentMimeType, null, (CmisTestResult)f));
        if (contentStream.getMimeType() != null) {
            if (contentMimeType.equals(docMimeType)) {
                f = this.createResult(CmisTestResultStatus.WARNING, "Content MIME types don't match!");
                this.addResult(results, this.assertEquals(doc.getContentStreamMimeType(), contentStream.getMimeType(), null, (CmisTestResult)f));
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Content MIME types is invalid: " + contentStream.getMimeType());
            this.addResult(results, this.assertIsTrue(contentStream.getMimeType().length() > 2 && contentStream.getMimeType().indexOf(47) > 0, null, f));
        }
        if ((stream = contentStream.getStream()) == null) {
            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Docuemnt has no content stream!"));
            return;
        }
        try {
            long bytes = 0L;
            byte[] buffer = new byte[65536];
            int b = stream.read(buffer);
            while (b > -1) {
                bytes += (long)b;
                b = stream.read(buffer);
            }
            stream.close();
            if (doc.getContentStreamLength() > -1L) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Content stream length property value doesn't match the actual content length!");
                this.addResult(results, this.assertEquals(doc.getContentStreamLength(), bytes, null, (CmisTestResult)f));
            }
            if (contentStream.getLength() > -1L) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Content length value doesn't match the actual content length!");
                this.addResult(results, this.assertEquals(contentStream.getLength(), bytes, null, (CmisTestResult)f));
            }
        }
        catch (Exception e) {
            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Reading content failed: " + e, e, false));
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CmisTestResult checkRenditions(Session session, CmisObject object, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (object.getRenditions() != null) {
            for (Rendition rend : object.getRenditions()) {
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "A rendition in the list of renditions is null!");
                this.addResult(results, this.assertNotNull(rend, null, f));
                if (rend == null) continue;
                f = this.createResult(CmisTestResultStatus.FAILURE, "A rendition has an empty stream id!");
                this.addResult(results, this.assertStringNotEmpty(rend.getStreamId(), null, f));
                f = this.createResult(CmisTestResultStatus.FAILURE, "A rendition has an empty kind! Stream id: " + rend.getStreamId());
                this.addResult(results, this.assertStringNotEmpty(rend.getKind(), null, f));
                f = this.createResult(CmisTestResultStatus.FAILURE, "A rendition has an empty MIME type! Stream id: " + rend.getStreamId());
                this.addResult(results, this.assertStringNotEmpty(rend.getMimeType(), null, f));
                if ("cmis:thumbnail".equals(rend.getKind())) {
                    f = this.createResult(CmisTestResultStatus.WARNING, "A rendition is of kind 'cmis:thumbnail' but the height is not set or has an invalid value! Stream id: " + rend.getStreamId());
                    this.addResult(results, this.assertIsTrue(rend.getHeight() > 0L, null, f));
                    f = this.createResult(CmisTestResultStatus.WARNING, "A rendition is of kind 'cmis:thumbnail' but the width is not set or has an invalid value! Stream id: " + rend.getStreamId());
                    this.addResult(results, this.assertIsTrue(rend.getWidth() > 0L, null, f));
                }
                ContentStream contentStream = rend.getContentStream();
                f = this.createResult(CmisTestResultStatus.FAILURE, "A rendition has no content stream! Stream id: " + rend.getStreamId());
                this.addResult(results, this.assertNotNull(contentStream, null, f));
                if (contentStream == null) continue;
                InputStream stream = contentStream.getStream();
                f = this.createResult(CmisTestResultStatus.FAILURE, "A rendition has no stream! Stream id: " + rend.getStreamId());
                this.addResult(results, this.assertNotNull(stream, null, f));
                if (stream == null) continue;
                try {
                    long bytes = 0L;
                    byte[] buffer = new byte[65536];
                    int b = stream.read(buffer);
                    while (b > -1) {
                        bytes += (long)b;
                        b = stream.read(buffer);
                    }
                    stream.close();
                    if (rend.getLength() <= -1L) continue;
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Rendition content stream length value doesn't match the actual content length!");
                    this.addResult(results, this.assertEquals(rend.getLength(), bytes, null, (CmisTestResult)f));
                }
                catch (Exception e) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Reading content failed: " + e, e, false));
                }
                finally {
                    IOUtils.closeQuietly((Closeable)stream);
                }
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult checkVersionHistory(Session session, CmisObject object, String[] properties, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (object.getBaseTypeId() != BaseTypeId.CMIS_DOCUMENT) {
            return null;
        }
        if (!Boolean.TRUE.equals(((DocumentTypeDefinition)object.getType()).isVersionable())) {
            return null;
        }
        Document doc = (Document)object;
        String versionSeriesId = doc.getVersionSeriesId();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Versionable document has no version series id property!");
        this.addResult(results, this.assertStringNotEmpty(versionSeriesId, null, f));
        if (versionSeriesId == null) {
            CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
            result.getChildren().addAll(results);
            return result;
        }
        List versions = doc.getAllVersions(SELECT_ALL_NO_CACHE_OC);
        f = this.createResult(CmisTestResultStatus.FAILURE, "Version history is null!");
        this.addResult(results, this.assertNotNull(versions, null, f));
        if (versions == null) {
            CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
            result.getChildren().addAll(results);
            return result;
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "Version history must have at least one version!");
        this.addResult(results, this.assertIsTrue(versions.size() > 0, null, f));
        if (versions.size() > 0) {
            Document lastestVersion = doc.getObjectOfLatestVersion(false, SELECT_ALL_NO_CACHE_OC);
            this.addResult(results, this.checkObject(session, (CmisObject)lastestVersion, properties, "Latest version check: " + lastestVersion.getId()));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Latest version is not flagged as latest version! Id: " + lastestVersion.getId());
            this.addResult(results, this.assertIsTrue(lastestVersion.isLatestVersion(), null, f));
            Document lastestMajorVersion = null;
            try {
                lastestMajorVersion = doc.getObjectOfLatestVersion(true, SELECT_ALL_NO_CACHE_OC);
                f = this.createResult(CmisTestResultStatus.FAILURE, "getObjectOfLatestVersion returned an invalid object!");
                this.addResult(results, this.assertNotNull(lastestMajorVersion, null, f));
            }
            catch (CmisObjectNotFoundException e) {
                // empty catch block
            }
            if (lastestMajorVersion != null) {
                this.addResult(results, this.checkObject(session, (CmisObject)lastestMajorVersion, properties, "Latest major version check: " + lastestMajorVersion.getId()));
                f = this.createResult(CmisTestResultStatus.FAILURE, "Latest major version is not flagged as latest major version! Id: " + lastestMajorVersion.getId());
                this.addResult(results, this.assertIsTrue(lastestMajorVersion.isLatestMajorVersion(), null, f));
            }
            long creatationDate = Long.MAX_VALUE;
            int latestVersion = 0;
            int latestMajorVersion = 0;
            long latestModificationDate = Long.MAX_VALUE;
            int latestModifictaionIndex = Integer.MIN_VALUE;
            HashSet<String> versionLabels = new HashSet<String>();
            boolean found = false;
            boolean foundLastestVersion = false;
            boolean foundLastestMajorVersion = false;
            for (int i = 0; i < versions.size(); ++i) {
                Document version = (Document)versions.get(i);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version " + i + " is null!");
                this.addResult(results, this.assertNotNull(version, null, f));
                if (version == null) continue;
                this.addResult(results, this.checkObject(session, (CmisObject)version, properties, "Version check: " + version.getId()));
                if (i == 0) {
                    if (version.isVersionSeriesCheckedOut().booleanValue()) {
                        f = this.createResult(CmisTestResultStatus.WARNING, "Version series is checked-out and the PWC is not the latest version! Id: " + version.getId() + " (Note: The words of the CMIS specification define that the PWC is the latest version." + " But that is not the intention of the spec and will be changed in CMIS 1.1." + " Thus this a warning, not an error.)");
                        this.addResult(results, this.assertIsTrue(version.isLatestVersion(), null, f));
                    } else {
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Version series is not checked-out and first version history entry is not the latest version! Id: " + version.getId());
                        this.addResult(results, this.assertIsTrue(version.isLatestVersion(), null, f));
                    }
                }
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version series id does not match! Id: " + version.getId());
                this.addResult(results, this.assertEquals(versionSeriesId, version.getVersionSeriesId(), null, (CmisTestResult)f));
                if (creatationDate == version.getCreationDate().getTimeInMillis()) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Two or more versions have the same creation date!"));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Version history order incorrect! Must be sorted bei creation date!");
                    this.addResult(results, this.assertIsTrue(version.getCreationDate().getTimeInMillis() <= creatationDate, null, f));
                }
                version.getCreationDate().getTimeInMillis();
                if (version.isLatestVersion().booleanValue()) {
                    ++latestVersion;
                }
                if (version.isLatestMajorVersion().booleanValue()) {
                    ++latestMajorVersion;
                }
                if (latestModificationDate == version.getLastModificationDate().getTimeInMillis()) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Two or more versions have the same last modification date!"));
                } else if (latestModificationDate < version.getLastModificationDate().getTimeInMillis()) {
                    latestModificationDate = version.getLastModificationDate().getTimeInMillis();
                    latestModifictaionIndex = i;
                }
                String versionLabel = version.getVersionLabel();
                f = this.createResult(CmisTestResultStatus.WARNING, "More than one version have this version label: " + versionLabel);
                this.addResult(results, this.assertIsFalse(versionLabels.contains(versionLabel), null, f));
                versionLabels.add(versionLabel);
                if (version.getId().equals(version.getVersionSeriesCheckedOutId())) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "PWC must not be flagged as latest major version! Id: " + version.getId());
                    this.addResult(results, this.assertIsFalse(version.isLatestMajorVersion(), null, f));
                }
                if (Boolean.TRUE.equals(doc.isVersionSeriesCheckedOut())) {
                    f = this.createResult(CmisTestResultStatus.WARNING, "Version series is marked as checked out but cmis:versionSeriesCheckedOutId is not set! Id: " + version.getId());
                    this.addResult(results, this.assertStringNotEmpty(doc.getVersionSeriesCheckedOutId(), null, f));
                    f = this.createResult(CmisTestResultStatus.WARNING, "Version series is marked as checked out but cmis:versionSeriesCheckedOutBy is not set! Id: " + version.getId());
                    this.addResult(results, this.assertStringNotEmpty(doc.getVersionSeriesCheckedOutBy(), null, f));
                } else if (Boolean.FALSE.equals(doc.isVersionSeriesCheckedOut())) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Version series is not marked as checked out but cmis:versionSeriesCheckedOutId is set! Id: " + version.getId());
                    this.addResult(results, this.assertNull(doc.getVersionSeriesCheckedOutId(), null, f));
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Version series is not marked as checked out but cmis:versionSeriesCheckedOutIdBy is set! Id: " + version.getId());
                    this.addResult(results, this.assertNull(doc.getVersionSeriesCheckedOutBy(), null, f));
                }
                if (version.getId().equals(object.getId())) {
                    found = true;
                }
                if (version.getId().equals(lastestVersion.getId())) {
                    foundLastestVersion = true;
                }
                if (lastestMajorVersion == null || !version.getId().equals(lastestMajorVersion.getId())) continue;
                foundLastestMajorVersion = true;
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Version series id has " + latestVersion + " latest versions! There must be only one!");
            this.addResult(results, this.assertEquals(1, latestVersion, null, (CmisTestResult)f));
            if (!foundLastestVersion) {
                this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Latest version not found in version history!"));
            }
            if (lastestMajorVersion == null) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version series id has " + latestMajorVersion + " latest major version(s) but getObjectOfLatestVersion() didn't return a major version!");
                this.addResult(results, this.assertEquals(0, latestMajorVersion, null, (CmisTestResult)f));
            } else {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version series id has " + latestMajorVersion + " latest major versions but there should be exactly one!");
                this.addResult(results, this.assertEquals(1, latestMajorVersion, null, (CmisTestResult)f));
                if (!foundLastestMajorVersion) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Latest major version not found in version history!"));
                }
            }
            if (latestModifictaionIndex >= 0) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Version with the latest modification date is not flagged as latest version! Id: " + versions.get(latestModifictaionIndex));
                this.addResult(results, this.assertIsTrue(((Document)versions.get(latestModifictaionIndex)).isLatestVersion(), null, f));
            }
            if (!found) {
                this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Document not found in its version history!"));
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult assertAllowableAction(CmisObject object, Action action, CmisTestResult success, CmisTestResult failure) {
        AllowableActions allowableActions = object.getAllowableActions();
        if (allowableActions != null && allowableActions.getAllowableActions() != null && allowableActions.getAllowableActions().contains(action)) {
            return success;
        }
        return failure;
    }

    protected CmisTestResult assertNotAllowableAction(CmisObject object, Action action, CmisTestResult success, CmisTestResult failure) {
        AllowableActions allowableActions = object.getAllowableActions();
        if (allowableActions != null && allowableActions.getAllowableActions() != null && !allowableActions.getAllowableActions().contains(action)) {
            return success;
        }
        return failure;
    }

    protected CmisTestResult checkProperty(Property<?> property, String message, PropertyCheckEnum propertyCheck) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Property is not included in response!");
        this.addResult(results, this.assertNotNull(property, null, f));
        if (property != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Property id is not set or empty!");
            this.addResult(results, this.assertStringNotEmpty(property.getId(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Display name is not set!");
            this.addResult(results, this.assertNotNull(property.getDisplayName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Query name is not set!");
            this.addResult(results, this.assertNotNull(property.getQueryName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Local name is not set!");
            this.addResult(results, this.assertNotNull(property.getLocalName(), null, f));
            if (propertyCheck == PropertyCheckEnum.MUST_BE_SET || propertyCheck == PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property has no value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() > 0, null, f));
            } else if (propertyCheck == PropertyCheckEnum.STRING_SHOULD_NOT_BE_EMPTY) {
                f = this.createResult(CmisTestResultStatus.WARNING, "Property has no value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() > 0, null, f));
            } else if (propertyCheck == PropertyCheckEnum.MUST_NOT_BE_SET) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property has a value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() == 0, null, f));
            }
            boolean isString = property.getDefinition().getPropertyType() == PropertyType.STRING || property.getDefinition().getPropertyType() == PropertyType.ID || property.getDefinition().getPropertyType() == PropertyType.URI || property.getDefinition().getPropertyType() == PropertyType.HTML;
            for (Object value : property.getValues()) {
                if (value == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Property values contain a null value!"));
                    break;
                }
                if (!isString) continue;
                if (propertyCheck == PropertyCheckEnum.STRING_MUST_NOT_BE_EMPTY) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Property values contain an empty string!");
                    this.addResult(results, this.assertStringNotEmpty(value.toString(), null, f));
                    continue;
                }
                if (propertyCheck != PropertyCheckEnum.STRING_SHOULD_NOT_BE_EMPTY) continue;
                f = this.createResult(CmisTestResultStatus.WARNING, "Property values contain an empty string!");
                this.addResult(results, this.assertStringNotEmpty(value.toString(), null, f));
            }
            if (property.getDefinition().getCardinality() == Cardinality.SINGLE) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property cardinality is SINGLE but property has more than one value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() <= 1, null, f));
            }
            if (property.getDefinition().isRequired() == null) {
                this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Property definition doesn't contain the required flag!"));
            } else if (property.getDefinition().isRequired().booleanValue()) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property is required but has no value!");
                this.addResult(results, this.assertIsTrue(property.getValues().size() > 0, null, f));
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult checkChildren(Session session, Folder folder, String message) {
        CmisTestResultImpl f;
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (folder == null) {
            return this.createResult(CmisTestResultStatus.FAILURE, "Folder is null!");
        }
        boolean supportsOrderByName = this.isOrderByNameSupported(session);
        OperationContext orderContext = supportsOrderByName ? SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME : SELECT_ALL_NO_CACHE_OC;
        long childrenCount = 0L;
        long childrenFolderCount = 0L;
        ItemIterable children = folder.getChildren(orderContext);
        int orderByNameIssues = 0;
        String lastName = null;
        for (CmisObject child : children) {
            ++childrenCount;
            if (child instanceof Folder) {
                ++childrenFolderCount;
            }
            this.checkChild(session, results, folder, child);
            if (lastName != null && child.getName() != null && child.getName().compareToIgnoreCase(lastName) < 0) {
                ++orderByNameIssues;
            }
            lastName = child.getName();
        }
        if (children.getTotalNumItems() >= 0L) {
            f = this.createResult(CmisTestResultStatus.WARNING, "Number of children doesn't match the reported total number of items!");
            this.addResult(results, this.assertEquals(childrenCount, children.getTotalNumItems(), null, (CmisTestResult)f));
        } else {
            this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "getChildren did not report the total number of items!"));
        }
        if (supportsOrderByName) {
            f = this.createResult(CmisTestResultStatus.WARNING, "Children should be ordered by cmis:name, but they are not! (It might be a collation mismtach.)");
            this.addResult(results, this.assertEquals(0, orderByNameIssues, null, (CmisTestResult)f));
        } else {
            this.addResult(results, this.createResult(CmisTestResultStatus.INFO, "Repository doesn't support Order By for getChildren()."));
        }
        if (this.isGetDescendantsSupported(session)) {
            long descendantsCount = 0L;
            List descendants = folder.getDescendants(1, SELECT_ALL_NO_CACHE_OC);
            for (Tree child : descendants) {
                ++descendantsCount;
                if (child == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Folder descendants contain a null tree!"));
                    continue;
                }
                this.checkChild(session, results, folder, (CmisObject)child.getItem());
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Number of descendants doesn't match the number of children returned by getChildren!");
            this.addResult(results, this.assertEquals(childrenCount, descendantsCount, null, (CmisTestResult)f));
        } else {
            this.addResult(results, this.createResult(CmisTestResultStatus.SKIPPED, "getDescendants is not supported."));
        }
        if (this.isGetFolderTreeSupported(session)) {
            long folderTreeCount = 0L;
            List folderTree = folder.getFolderTree(1, SELECT_ALL_NO_CACHE_OC);
            for (Tree child : folderTree) {
                ++folderTreeCount;
                if (child == null) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Folder tree contains a null tree!"));
                    continue;
                }
                this.checkChild(session, results, folder, (CmisObject)child.getItem());
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Number of folders doesn't match the number of folders returned by getChildren!");
            this.addResult(results, this.assertEquals(childrenFolderCount, folderTreeCount, null, (CmisTestResult)f));
        } else {
            this.addResult(results, this.createResult(CmisTestResultStatus.SKIPPED, "getFolderTree is not supported."));
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    private void checkChild(Session session, List<CmisTestResult> results, Folder folder, CmisObject child) {
        if (child == null) {
            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Folder contains a null child!"));
        } else {
            String[] propertiesToCheck = new String[child.getType().getPropertyDefinitions().size()];
            int i = 0;
            for (String propId : child.getType().getPropertyDefinitions().keySet()) {
                propertiesToCheck[i++] = propId;
            }
            this.addResult(results, this.checkObject(session, child, propertiesToCheck, "Child check: " + child.getId()));
            this.addResult(results, this.checkVersionHistory(session, child, propertiesToCheck, "Child version history check: " + child.getId()));
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Child is not fileable! Id: " + child.getId() + " / Type: " + child.getType().getId());
            this.addResult(results, this.assertIsTrue(child instanceof FileableCmisObject, null, f));
            if (child instanceof FileableCmisObject) {
                FileableCmisObject fileableChild = (FileableCmisObject)child;
                Set actions = fileableChild.getAllowableActions().getAllowableActions();
                boolean hasObjectParentsAction = actions.contains(Action.CAN_GET_OBJECT_PARENTS);
                boolean hasFolderParentAction = actions.contains(Action.CAN_GET_FOLDER_PARENT);
                if (hasObjectParentsAction || hasFolderParentAction) {
                    List parents = fileableChild.getParents();
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Child has no parents! Id: " + child.getId());
                    this.addResult(results, this.assertIsTrue(parents.size() > 0, null, f));
                    boolean foundParent = false;
                    for (Folder parent : parents) {
                        if (parent == null) {
                            f = this.createResult(CmisTestResultStatus.FAILURE, "One of childs parents is null! Id: " + child.getId());
                            this.addResult(results, this.assertIsTrue(parents.size() > 0, null, f));
                            continue;
                        }
                        if (!folder.getId().equals(parent.getId())) continue;
                        foundParent = true;
                        break;
                    }
                    if (!foundParent) {
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Folder is not found in childs parents! Id: " + child.getId());
                        this.addResult(results, this.assertIsTrue(parents.size() > 0, null, f));
                    }
                }
                CmisObject objectById = session.getObject(child.getId(), SELECT_ALL_NO_CACHE_OC);
                f = this.createResult(CmisTestResultStatus.FAILURE, "Child and object fetched by id don't match! Id: " + child.getId());
                this.addResult(results, this.assertEquals(child, objectById, null, f, false, false));
                List paths = ((FileableCmisObject)child).getPaths();
                if (paths == null || paths.isEmpty()) {
                    this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "Child has no path! " + child.getId()));
                } else {
                    for (String path : paths) {
                        CmisObject objectByPath = session.getObjectByPath(path, SELECT_ALL_NO_CACHE_OC);
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Child and object fetched by path don't match! Id: " + child.getId() + " / Path: " + path);
                        this.addResult(results, this.assertEquals(child, objectByPath, null, f, false, false));
                        f = this.createResult(CmisTestResultStatus.FAILURE, "Object fetched by id and object fetched by path don't match! Id: " + child.getId() + " / Path: " + path);
                        this.addResult(results, this.assertEquals(objectById, objectByPath, null, f, true, true));
                    }
                }
            }
            f = this.createResult(CmisTestResultStatus.WARNING, "Child has no CAN_GET_OBJECT_PARENTS allowable action! Id: " + child.getId());
            this.addResult(results, this.assertAllowableAction(child, Action.CAN_GET_OBJECT_PARENTS, null, f));
            if (child instanceof Folder) {
                f = this.createResult(CmisTestResultStatus.WARNING, "Child has no CAN_GET_FOLDER_PARENT allowable action! Id: " + child.getId());
                this.addResult(results, this.assertAllowableAction(child, Action.CAN_GET_FOLDER_PARENT, null, f));
            }
        }
    }

    protected CmisTestResult assertShallowEquals(CmisObject expected, CmisObject actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected object is null, but actual object is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual object is null, but expected object is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Ids don't match!");
        this.addResult(results, this.assertEquals(expected.getId(), actual.getId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Base types don't match!");
        this.addResult(results, this.assertEquals(expected.getBaseTypeId(), actual.getBaseTypeId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Types don't match!");
        this.addResult(results, this.assertEquals(expected.getType().getId(), actual.getType().getId(), null, (CmisTestResult)f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult checkQueryName(String queryName, boolean isRequired, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (queryName == null || queryName.length() == 0) {
            this.addResult(results, this.createResult(isRequired ? CmisTestResultStatus.FAILURE : CmisTestResultStatus.WARNING, "Query name is not set!"));
        } else {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: ' '");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(32) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: ','");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(44) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: '\"'");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(34) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: '''");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(39) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: '\\'");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(92) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: '.'");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(46) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: '('");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(40) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: ')'");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(41) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: '\\t'");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(9) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: '\\n'");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(10) < 0, null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name contains invalid character: '\\r'");
            this.addResult(results, this.assertIsTrue(queryName.indexOf(13) < 0, null, f));
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult checkTypeDefinition(Session session, TypeDefinition type, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Type is null!");
        this.addResult(results, this.assertNotNull(type, null, f));
        if (type != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Type id is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getId(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Base type id is not set!");
            this.addResult(results, this.assertNotNull(type.getBaseTypeId(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Local name is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getLocalName(), null, f));
            boolean isQueryNameRequired = Boolean.TRUE.equals(type.isQueryable());
            this.addResult(results, this.checkQueryName(type.getQueryName(), isQueryNameRequired, "Type Query Name: " + type.getQueryName()));
            if (type.getId() != null && type.getBaseTypeId() != null) {
                if (type.getBaseTypeId().value().equals(type.getId())) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Base type has parent type!");
                    this.addResult(results, this.assertStringNullOrEmpty(type.getParentTypeId(), null, f));
                } else {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Parent type is not set!");
                    this.addResult(results, this.assertStringNotEmpty(type.getParentTypeId(), null, f));
                }
            }
            f = this.createResult(CmisTestResultStatus.FAILURE, "Creatable flag is not set!");
            this.addResult(results, this.assertNotNull(type.isCreatable(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Fileable flag is not set!");
            this.addResult(results, this.assertNotNull(type.isFileable(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Controllable ACL flag is not set!");
            this.addResult(results, this.assertNotNull(type.isControllableAcl(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Controllable Policy flag is not set!");
            this.addResult(results, this.assertNotNull(type.isControllablePolicy(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Fulltext indexed flag is not set!");
            this.addResult(results, this.assertNotNull(type.isFulltextIndexed(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Included in super type flag is not set!");
            this.addResult(results, this.assertNotNull(type.isIncludedInSupertypeQuery(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Queryable flag is not set!");
            this.addResult(results, this.assertNotNull(type.isQueryable(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Type display name is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getDisplayName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Type description is not set!");
            this.addResult(results, this.assertStringNotEmpty(type.getDescription(), null, f));
            if (BaseTypeId.CMIS_DOCUMENT.equals((Object)type.getBaseTypeId())) {
                DocumentTypeDefinition docType = (DocumentTypeDefinition)type;
                f = this.createResult(CmisTestResultStatus.FAILURE, "Versionable flag is not set!");
                this.addResult(results, this.assertNotNull(docType.isVersionable(), null, f));
                f = this.createResult(CmisTestResultStatus.FAILURE, "Content stream allowed flag is not set!");
                this.addResult(results, this.assertNotNull(docType.getContentStreamAllowed(), null, f));
            } else if (BaseTypeId.CMIS_FOLDER.equals((Object)type.getBaseTypeId())) {
                if (type.isFileable() != null) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Folder types must be fileable!");
                    this.addResult(results, this.assertIsTrue(type.isFileable(), null, f));
                }
            } else if (BaseTypeId.CMIS_RELATIONSHIP.equals((Object)type.getBaseTypeId())) {
                RelationshipTypeDefinition relType = (RelationshipTypeDefinition)type;
                f = this.createResult(CmisTestResultStatus.FAILURE, "Allowed Source Type Ids are not set!");
                this.addResult(results, this.assertNotNull(relType.getAllowedSourceTypeIds(), null, f));
                if (relType.getAllowedSourceTypeIds() != null) {
                    for (String typeId : relType.getAllowedSourceTypeIds()) {
                        try {
                            session.getTypeDefinition(typeId);
                        }
                        catch (CmisInvalidArgumentException e) {
                            this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Allowed Source Type Ids contain a type id that doesn't exist: " + typeId));
                        }
                        catch (CmisObjectNotFoundException e) {
                            this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Allowed Source Type Ids contain a type id that doesn't exist: " + typeId));
                        }
                    }
                }
                f = this.createResult(CmisTestResultStatus.FAILURE, "Allowed Target Type Ids are not set!");
                this.addResult(results, this.assertNotNull(relType.getAllowedTargetTypeIds(), null, f));
                if (relType.getAllowedTargetTypeIds() != null) {
                    for (String typeId : relType.getAllowedTargetTypeIds()) {
                        try {
                            session.getTypeDefinition(typeId);
                        }
                        catch (CmisInvalidArgumentException e) {
                            this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Allowed Target Type Ids contain a type id that doesn't exist: " + typeId));
                        }
                        catch (CmisObjectNotFoundException e) {
                            this.addResult(results, this.createResult(CmisTestResultStatus.WARNING, "Allowed Target Type Ids contain a type id that doesn't exist: " + typeId));
                        }
                    }
                }
                if (type.isFileable() != null) {
                    f = this.createResult(CmisTestResultStatus.FAILURE, "Relationship types must not be fileable!");
                    this.addResult(results, this.assertIsFalse(type.isFileable(), null, f));
                }
            } else if (BaseTypeId.CMIS_POLICY.equals((Object)type.getBaseTypeId())) {
                // empty if block
            }
            if (!BaseTypeId.CMIS_SECONDARY.equals((Object)type.getBaseTypeId())) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Type has no property definitions!");
                this.addResult(results, this.assertNotNull(type.getPropertyDefinitions(), null, f));
                if (type.getPropertyDefinitions() != null) {
                    for (PropertyDefinition propDef : type.getPropertyDefinitions().values()) {
                        if (propDef == null) {
                            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "A property definition is null!"));
                            continue;
                        }
                        if (propDef.getId() == null) {
                            this.addResult(results, this.createResult(CmisTestResultStatus.FAILURE, "A property definition id is null!"));
                            continue;
                        }
                        this.addResult(results, this.checkPropertyDefinition(propDef, "Property definition: " + propDef.getId()));
                    }
                }
                CmisPropertyDefintion cpd = new CmisPropertyDefintion("cmis:name", null, PropertyType.STRING, Cardinality.SINGLE, null, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:objectId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:baseTypeId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:objectTypeId", true, PropertyType.ID, Cardinality.SINGLE, Updatability.ONCREATE, null, null);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:createdBy", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, true, true);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:creationDate", false, PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, true, true);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:lastModifiedBy", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, true, true);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:lastModificationDate", false, PropertyType.DATETIME, Cardinality.SINGLE, Updatability.READONLY, true, true);
                this.addResult(results, cpd.check(type));
                cpd = new CmisPropertyDefintion("cmis:changeToken", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                this.addResult(results, cpd.check(type));
                if (session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_1) {
                    cpd = new CmisPropertyDefintion("cmis:description", null, PropertyType.STRING, Cardinality.SINGLE, null, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:secondaryObjectTypeIds", false, PropertyType.ID, Cardinality.MULTI, null, null, false);
                    this.addResult(results, cpd.check(type));
                    if (BaseTypeId.CMIS_DOCUMENT.equals((Object)type.getBaseTypeId())) {
                        cpd = new CmisPropertyDefintion("cmis:isPrivateWorkingCopy", null, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                        this.addResult(results, cpd.check(type));
                    }
                }
                if (BaseTypeId.CMIS_DOCUMENT.equals((Object)type.getBaseTypeId())) {
                    cpd = new CmisPropertyDefintion("cmis:isImmutable", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:isLatestVersion", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:isMajorVersion", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:isLatestMajorVersion", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:versionLabel", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:versionSeriesId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:isVersionSeriesCheckedOut", false, PropertyType.BOOLEAN, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:versionSeriesCheckedOutBy", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:versionSeriesCheckedOutId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:checkinComment", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:contentStreamLength", false, PropertyType.INTEGER, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:contentStreamMimeType", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:contentStreamFileName", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:contentStreamId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                } else if (BaseTypeId.CMIS_FOLDER.equals((Object)type.getBaseTypeId())) {
                    cpd = new CmisPropertyDefintion("cmis:parentId", false, PropertyType.ID, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:path", false, PropertyType.STRING, Cardinality.SINGLE, Updatability.READONLY, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:allowedChildObjectTypeIds", false, PropertyType.ID, Cardinality.MULTI, Updatability.READONLY, null, false);
                    this.addResult(results, cpd.check(type));
                } else if (BaseTypeId.CMIS_RELATIONSHIP.equals((Object)type.getBaseTypeId())) {
                    cpd = new CmisPropertyDefintion("cmis:sourceId", true, PropertyType.ID, Cardinality.SINGLE, null, null, null);
                    this.addResult(results, cpd.check(type));
                    cpd = new CmisPropertyDefintion("cmis:targetId", true, PropertyType.ID, Cardinality.SINGLE, null, null, null);
                    this.addResult(results, cpd.check(type));
                } else if (BaseTypeId.CMIS_POLICY.equals((Object)type.getBaseTypeId())) {
                    cpd = new CmisPropertyDefintion("cmis:policyText", null, PropertyType.STRING, Cardinality.SINGLE, null, null, null);
                    this.addResult(results, cpd.check(type));
                }
            }
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult checkPropertyDefinition(PropertyDefinition<?> propDef, String message) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Property definition is null!");
        this.addResult(results, this.assertNotNull(propDef, null, f));
        if (propDef != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Property id is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getId(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Local name is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getLocalName(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Query name is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getQueryName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Display name is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getDisplayName(), null, f));
            f = this.createResult(CmisTestResultStatus.WARNING, "Description is not set!");
            this.addResult(results, this.assertStringNotEmpty(propDef.getDescription(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Property type is not set!");
            this.addResult(results, this.assertNotNull(propDef.getPropertyType(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Cardinality is not set!");
            this.addResult(results, this.assertNotNull(propDef.getCardinality(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Updatability is not set!");
            this.addResult(results, this.assertNotNull(propDef.getUpdatability(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Inherited flag is not set!");
            this.addResult(results, this.assertNotNull(propDef.isInherited(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Required flag is not set!");
            this.addResult(results, this.assertNotNull(propDef.isRequired(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Queryable flag is not set!");
            this.addResult(results, this.assertNotNull(propDef.isQueryable(), null, f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Orderable flag is not set!");
            this.addResult(results, this.assertNotNull(propDef.isOrderable(), null, f));
        }
        CmisTestResultImpl result = this.createResult(this.getWorst(results), message);
        result.getChildren().addAll(results);
        return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
    }

    protected CmisTestResult assertEquals(TypeDefinition expected, TypeDefinition actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected type defintion is null, but actual type defintion is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual type defintion is null, but expected type defintion is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Type ids don't match!");
        this.addResult(results, this.assertEquals(expected.getId(), actual.getId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Base type ids don't match!");
        this.addResult(results, this.assertEquals(expected.getBaseTypeId(), actual.getBaseTypeId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Parent type ids don't match!");
        this.addResult(results, this.assertEquals(expected.getParentTypeId(), actual.getParentTypeId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Query names don't match!");
        this.addResult(results, this.assertEquals(expected.getQueryName(), actual.getQueryName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Local names don't match!");
        this.addResult(results, this.assertEquals(expected.getLocalName(), actual.getLocalName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Local namespaces don't match!");
        this.addResult(results, this.assertEquals(expected.getLocalNamespace(), actual.getLocalNamespace(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Display names don't match!");
        this.addResult(results, this.assertEquals(expected.getDisplayName(), actual.getDisplayName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Descriptions don't match!");
        this.addResult(results, this.assertEquals(expected.getDescription(), actual.getDescription(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Controllable ACl flags don't match!");
        this.addResult(results, this.assertEquals(expected.isControllableAcl(), actual.isControllableAcl(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Controllable Policy flags don't match!");
        this.addResult(results, this.assertEquals(expected.isControllablePolicy(), actual.isControllablePolicy(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Creatable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isCreatable(), actual.isCreatable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Fileable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isFileable(), actual.isFileable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Fulltext indexed flags don't match!");
        this.addResult(results, this.assertEquals(expected.isFulltextIndexed(), actual.isFulltextIndexed(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Queryable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isQueryable(), actual.isQueryable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Included in supertype query flags don't match!");
        this.addResult(results, this.assertEquals(expected.isIncludedInSupertypeQuery(), actual.isIncludedInSupertypeQuery(), null, (CmisTestResult)f));
        if (expected.getTypeMutability() != null && actual.getTypeMutability() != null) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Type Mutability: Create flags don't match!");
            this.addResult(results, this.assertEquals(expected.getTypeMutability().canCreate(), actual.getTypeMutability().canCreate(), null, (CmisTestResult)f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Type Mutability: update flags don't match!");
            this.addResult(results, this.assertEquals(expected.getTypeMutability().canUpdate(), actual.getTypeMutability().canUpdate(), null, (CmisTestResult)f));
            f = this.createResult(CmisTestResultStatus.FAILURE, "Type Mutability: delete flags don't match!");
            this.addResult(results, this.assertEquals(expected.getTypeMutability().canDelete(), actual.getTypeMutability().canDelete(), null, (CmisTestResult)f));
        } else {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Type Mutability infos don't match!");
            this.addResult(results, this.assertEquals(expected.getTypeMutability(), actual.getTypeMutability(), null, (CmisTestResult)f));
        }
        if (expected.getPropertyDefinitions() != null && actual.getPropertyDefinitions() != null) {
            Map epd = expected.getPropertyDefinitions();
            Map apd = actual.getPropertyDefinitions();
            f = this.createResult(CmisTestResultStatus.FAILURE, "Different number of property defintions!");
            this.addResult(results, this.assertEquals(epd.size(), apd.size(), null, (CmisTestResult)f));
            for (PropertyDefinition pd : epd.values()) {
                f = this.createResult(CmisTestResultStatus.FAILURE, "Property definition mismatch: " + pd.getId());
                this.addResult(results, this.assertEquals((PropertyDefinition<?>)pd, (PropertyDefinition<?>)((PropertyDefinition)apd.get(pd.getId())), (CmisTestResult)null, (CmisTestResult)f));
            }
        }
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(PropertyDefinition<?> expected, PropertyDefinition<?> actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected property defintion is null, but actual property defintion is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual property defintion is null, but expected property defintion is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Property ids don't match!");
        this.addResult(results, this.assertEquals(expected.getId(), actual.getId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Local names don't match!");
        this.addResult(results, this.assertEquals(expected.getLocalName(), actual.getLocalName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Local namespaces don't match!");
        this.addResult(results, this.assertEquals(expected.getLocalNamespace(), actual.getLocalNamespace(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Display names don't match!");
        this.addResult(results, this.assertEquals(expected.getDisplayName(), actual.getDisplayName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Query names don't match!");
        this.addResult(results, this.assertEquals(expected.getQueryName(), actual.getQueryName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Property types don't match!");
        this.addResult(results, this.assertEquals(expected.getPropertyType(), actual.getPropertyType(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Cardinalities don't match!");
        this.addResult(results, this.assertEquals(expected.getCardinality(), actual.getCardinality(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Descriptions don't match!");
        this.addResult(results, this.assertEquals(expected.getDescription(), actual.getDescription(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Updatability flags don't match!");
        this.addResult(results, this.assertEquals(expected.getUpdatability(), actual.getUpdatability(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Default values don't match!");
        this.addResult(results, this.assertEqualLists(expected.getDefaultValue(), actual.getDefaultValue(), null, f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Inherited flags don't match!");
        this.addResult(results, this.assertEquals(expected.isInherited(), actual.isInherited(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Required flags don't match!");
        this.addResult(results, this.assertEquals(expected.isRequired(), actual.isRequired(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Queryable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isQueryable(), actual.isQueryable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Orderable flags don't match!");
        this.addResult(results, this.assertEquals(expected.isOrderable(), actual.isOrderable(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Open choice flags don't match!");
        this.addResult(results, this.assertEquals(expected.isOpenChoice(), actual.isOpenChoice(), null, (CmisTestResult)f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(CmisObject expected, CmisObject actual, CmisTestResult success, CmisTestResult failure, boolean checkAcls, boolean checkPolicies) {
        CmisTestResultImpl f;
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f2 = this.createResult(CmisTestResultStatus.FAILURE, "Expected object is null, but actual object is not!");
            this.addResultChild(failure, f2);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f3 = this.createResult(CmisTestResultStatus.FAILURE, "Actual object is null, but expected object is not!");
            this.addResultChild(failure, f3);
            return failure;
        }
        if (expected.getProperties().size() != actual.getProperties().size()) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Number of properties don't match");
            this.addResult(results, this.assertEquals(expected.getProperties().size(), actual.getProperties().size(), null, (CmisTestResult)f));
        } else {
            for (Property expectedProperty : expected.getProperties()) {
                Property actualProperty = actual.getProperty(expectedProperty.getId());
                f = this.createResult(CmisTestResultStatus.FAILURE, "Properties don't match! Property: " + expectedProperty.getId());
                this.addResult(results, this.assertEquals((Property<?>)expectedProperty, (Property<?>)actualProperty, (CmisTestResult)null, (CmisTestResult)f));
            }
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "Allowable actions don't match!");
        this.addResult(results, this.assertEquals(expected.getAllowableActions(), actual.getAllowableActions(), (CmisTestResult)null, (CmisTestResult)f));
        if (checkAcls) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "ACLs don't match!");
            this.addResult(results, this.assertEquals(expected.getAcl(), actual.getAcl(), (CmisTestResult)null, (CmisTestResult)f));
        }
        if (checkPolicies) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Policies don't match!");
            this.addResult(results, this.assertEqualObjectList(expected.getPolicies(), actual.getPolicies(), null, f));
        }
        f = this.createResult(CmisTestResultStatus.FAILURE, "Relationships don't match!");
        this.addResult(results, this.assertEqualObjectList(expected.getRelationships(), actual.getRelationships(), null, f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Renditions don't match!");
        this.addResult(results, this.assertEqualRenditionLists(expected.getRenditions(), actual.getRenditions(), null, f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEqualObjectList(List<? extends CmisObject> expected, List<? extends CmisObject> actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected list of CMIS objects is null, but actual list of CMIS objects is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual list of CMIS objects is null, but expected list of CMIS objects is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (expected.size() != actual.size()) {
            this.addResult(results, this.createResult(CmisTestResultStatus.INFO, "Object list sizes don't match! expected: " + expected.size() + " / actual: " + actual.size()));
        } else {
            for (int i = 0; i < expected.size(); ++i) {
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Objects at position " + i + "  dont't match!");
                this.addResult(results, this.assertEquals(expected.get(i), actual.get(i), null, f, true, false));
            }
        }
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(Property<?> expected, Property<?> actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected property is null, but actual property is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual property is null, but expected property is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Property definitions don't match!");
        this.addResult(results, this.assertEquals((PropertyDefinition<?>)expected.getDefinition(), (PropertyDefinition<?>)actual.getDefinition(), (CmisTestResult)null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Property values don't match!");
        this.addResult(results, this.assertEqualLists(expected.getValues(), actual.getValues(), null, f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(AllowableActions expected, AllowableActions actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected allowable actions are null, but actual allowable actions are not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual allowable actions are null, but expected allowable actions are not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Allowable action sets don't match!");
        this.addResult(results, this.assertEqualSet(expected.getAllowableActions(), actual.getAllowableActions(), null, f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(Acl expected, Acl actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected ACL is null, but actual ACL is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual ACL is null, but expected ACL is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "ACEs don't match!");
        this.addResult(results, this.assertEqualAceLists(expected.getAces(), actual.getAces(), null, f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Exact flags dont't match!");
        this.addResult(results, this.assertEquals(expected.isExact(), actual.isExact(), null, (CmisTestResult)f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEqualAceLists(List<Ace> expected, List<Ace> actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Expected ACE list is null!"));
        }
        if (actual == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Actual ACE list is null!"));
        }
        if (expected.size() != actual.size()) {
            this.addResult(results, this.createResult(CmisTestResultStatus.INFO, "ACE list sizes don't match! expected: " + expected.size() + " / actual: " + actual.size()));
        } else {
            for (int i = 0; i < expected.size(); ++i) {
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "ACEs at position " + i + "  dont't match!");
                this.addResult(results, this.assertEquals(expected.get(i), actual.get(i), (CmisTestResult)null, (CmisTestResult)f));
            }
        }
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(Ace expected, Ace actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected ACE is null, but actual ACE is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual ACE is null, but expected ACE is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Principal ids dont't match!");
        this.addResult(results, this.assertEquals(expected.getPrincipalId(), actual.getPrincipalId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Permissions dont't match!");
        this.addResult(results, this.assertEqualLists(expected.getPermissions(), actual.getPermissions(), null, f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEqualRenditionLists(List<Rendition> expected, List<Rendition> actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Expected rendition list is null!"));
        }
        if (actual == null) {
            return this.addResultChild(failure, this.createResult(CmisTestResultStatus.INFO, "Actual rendition list is null!"));
        }
        if (expected.size() != actual.size()) {
            this.addResult(results, this.createResult(CmisTestResultStatus.INFO, "Rendition list sizes don't match! expected: " + expected.size() + " / actual: " + actual.size()));
        } else {
            for (int i = 0; i < expected.size(); ++i) {
                CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Renditions at position " + i + "  dont't match!");
                this.addResult(results, this.assertEquals(expected.get(i), actual.get(i), (CmisTestResult)null, (CmisTestResult)f));
            }
        }
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(Rendition expected, Rendition actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected rendition is null, but actual rendition is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual rendition is null, but expected rendition is not!");
            this.addResultChild(failure, f);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Stream ids dont't match!");
        this.addResult(results, this.assertEquals(expected.getStreamId(), actual.getStreamId(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Kinds dont't match!");
        this.addResult(results, this.assertEquals(expected.getKind(), actual.getKind(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "MIME types dont't match!");
        this.addResult(results, this.assertEquals(expected.getMimeType(), actual.getMimeType(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Titles dont't match!");
        this.addResult(results, this.assertEquals(expected.getTitle(), actual.getTitle(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Lengths dont't match!");
        this.addResult(results, this.assertEquals(expected.getLength(), actual.getLength(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Heights dont't match!");
        this.addResult(results, this.assertEquals(expected.getBigHeight(), actual.getBigHeight(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Widths dont't match!");
        this.addResult(results, this.assertEquals(expected.getBigWidth(), actual.getBigWidth(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "Rendition document ids dont't match!");
        this.addResult(results, this.assertEquals(expected.getRenditionDocumentId(), actual.getRenditionDocumentId(), null, (CmisTestResult)f));
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected CmisTestResult assertEquals(ContentStream expected, ContentStream actual, CmisTestResult success, CmisTestResult failure) {
        ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
        if (expected == null && actual == null) {
            return success;
        }
        if (expected == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Expected stream is null, but actual stream is not!");
            this.addResultChild(failure, f);
            IOUtils.closeQuietly((ContentStream)actual);
            return failure;
        }
        if (actual == null) {
            CmisTestResultImpl f = this.createResult(CmisTestResultStatus.FAILURE, "Actual object is null, but expected object is not!");
            this.addResultChild(failure, f);
            IOUtils.closeQuietly((ContentStream)expected);
            return failure;
        }
        CmisTestResultImpl f = this.createResult(CmisTestResultStatus.WARNING, "Filenames don't match!");
        this.addResult(results, this.assertEquals(expected.getFileName(), actual.getFileName(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.FAILURE, "MIME types don't match!");
        this.addResult(results, this.assertEquals(expected.getMimeType(), actual.getMimeType(), null, (CmisTestResult)f));
        f = this.createResult(CmisTestResultStatus.WARNING, "Lengths don't match!");
        this.addResult(results, this.assertEquals(expected.getBigLength(), actual.getBigLength(), null, (CmisTestResult)f));
        boolean match = true;
        BufferedInputStream as = new BufferedInputStream(actual.getStream());
        BufferedInputStream es = new BufferedInputStream(expected.getStream());
        try {
            int ab = 0;
            int eb = 0;
            while (true) {
                if (ab > -1) {
                    ab = as.read();
                }
                if (eb > -1) {
                    eb = es.read();
                }
                if (ab != -1 || eb != -1) {
                    if (ab == eb) continue;
                    match = false;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            f = this.createResult(CmisTestResultStatus.UNEXPECTED_EXCEPTION, e.getMessage(), e, false);
            this.addResultChild(failure, f);
        }
        if (!match) {
            f = this.createResult(CmisTestResultStatus.FAILURE, "Content streams don't match!");
            this.addResultChild(failure, f);
        }
        IOUtils.closeQuietly((Closeable)as);
        IOUtils.closeQuietly((Closeable)es);
        if (this.getWorst(results).getLevel() <= CmisTestResultStatus.OK.getLevel()) {
            for (CmisTestResult result : results) {
                this.addResultChild(success, result);
            }
            return success;
        }
        for (CmisTestResult result : results) {
            this.addResultChild(failure, result);
        }
        return failure;
    }

    protected void addResult(List<CmisTestResult> results, CmisTestResult result) {
        if (result != null) {
            if (result instanceof CmisTestResultImpl) {
                ((CmisTestResultImpl)result).setStackTrace(this.getStackTrace());
            }
            results.add(result);
            if (result.isFatal()) {
                throw new FatalTestException(result.getMessage());
            }
        }
    }

    protected CmisTestResultStatus getWorst(List<CmisTestResult> results) {
        if (results == null || results.isEmpty()) {
            return CmisTestResultStatus.OK;
        }
        int max = 0;
        for (CmisTestResult result : results) {
            if (max >= result.getStatus().getLevel()) continue;
            max = result.getStatus().getLevel();
        }
        return CmisTestResultStatus.fromLevel(max);
    }

    static {
        SELECT_ALL_NO_CACHE_OC.setFilterString("*");
        SELECT_ALL_NO_CACHE_OC.setCacheEnabled(false);
        SELECT_ALL_NO_CACHE_OC.setIncludeAllowableActions(true);
        SELECT_ALL_NO_CACHE_OC.setIncludeAcls(true);
        SELECT_ALL_NO_CACHE_OC.setIncludePathSegments(true);
        SELECT_ALL_NO_CACHE_OC.setIncludePolicies(true);
        SELECT_ALL_NO_CACHE_OC.setIncludeRelationships(IncludeRelationships.BOTH);
        SELECT_ALL_NO_CACHE_OC.setRenditionFilterString("*");
        SELECT_ALL_NO_CACHE_OC.setOrderBy(null);
        SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME = new OperationContextImpl(SELECT_ALL_NO_CACHE_OC);
        SELECT_ALL_NO_CACHE_OC_ORDER_BY_NAME.setOrderBy("cmis:name");
    }

    public class CmisPropertyDefintion {
        private final String id;
        private final Boolean required;
        private final PropertyType propertyType;
        private final Cardinality cardinality;
        private final Updatability updatability;
        private final Boolean queryable;
        private final Boolean orderable;

        public CmisPropertyDefintion(String id, Boolean required, PropertyType propertyType, Cardinality cardinality, Updatability updatability, Boolean queryable, Boolean orderable) {
            this.id = id;
            this.required = required;
            this.propertyType = propertyType;
            this.cardinality = cardinality;
            this.updatability = updatability;
            this.queryable = queryable;
            this.orderable = cardinality == Cardinality.MULTI ? Boolean.FALSE : orderable;
        }

        public CmisTestResult check(TypeDefinition type) {
            ArrayList<CmisTestResult> results = new ArrayList<CmisTestResult>();
            Map propDefs = type.getPropertyDefinitions();
            if (propDefs == null) {
                AbstractSessionTest.this.addResult(results, AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Property definitions are missing!"));
            } else {
                PropertyDefinition propDef = (PropertyDefinition)propDefs.get(this.id);
                if (propDef == null) {
                    AbstractSessionTest.this.addResult(results, AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Property definition is missing!"));
                } else {
                    Boolean inherited;
                    CmisTestResultImpl f;
                    if (this.required != null && !this.required.equals(propDef.isRequired())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Required flag: expected: " + this.required + " / actual: " + propDef.isRequired());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (!this.propertyType.equals((Object)propDef.getPropertyType())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Property type: expected: " + this.propertyType + " / actual: " + propDef.getPropertyType());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (!this.cardinality.equals((Object)propDef.getCardinality())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Cardinality: expected: " + this.cardinality + " / actual: " + propDef.getCardinality());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (this.updatability != null && !this.updatability.equals((Object)propDef.getUpdatability())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Updatability: expected: " + this.updatability + " / actual: " + propDef.getUpdatability());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (this.queryable != null && !this.queryable.equals(propDef.isQueryable())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Queryable: expected: " + this.queryable + " / actual: " + propDef.isQueryable());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    boolean isPropertyQueryNameRequired = Boolean.TRUE.equals(this.queryable);
                    AbstractSessionTest.this.checkQueryName(propDef.getQueryName(), isPropertyQueryNameRequired, "Property Query Name: " + propDef.getQueryName());
                    if (this.orderable != null && !this.orderable.equals(propDef.isOrderable())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Orderable: expected: " + this.orderable + " / actual: " + propDef.isOrderable());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                    if (type.getBaseTypeId() != null && !(inherited = Boolean.valueOf(!type.getBaseTypeId().value().equals(type.getId()))).equals(propDef.isInherited())) {
                        f = AbstractSessionTest.this.createResult(CmisTestResultStatus.FAILURE, "Inhertited: expected: " + inherited + " / actual: " + propDef.isInherited());
                        AbstractSessionTest.this.addResult(results, f);
                    }
                }
            }
            CmisTestResultImpl result = AbstractSessionTest.this.createResult(AbstractSessionTest.this.getWorst(results), "Property definition: " + this.id);
            result.getChildren().addAll(results);
            return result.getStatus().getLevel() <= CmisTestResultStatus.OK.getLevel() ? null : result;
        }
    }
}

