/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.chemistry.opencmis.tck.impl;

public final class TestParameters {

    public static final String DEFAULT_FOLDER_TYPE = "org.apache.chemistry.opencmis.tck.default.folderType";
    public static final String DEFAULT_FOLDER_TYPE_VALUE = "cmis:folder";

    public static final String DEFAULT_DOCUMENT_TYPE = "org.apache.chemistry.opencmis.tck.default.documentType";
    public static final String DEFAULT_DOCUMENT_TYPE_VALUE = "cmis:document";

    public static final String DEFAULT_RELATIONSHIP_TYPE = "org.apache.chemistry.opencmis.tck.default.relationshipType";
    public static final String DEFAULT_RELATIONSHIP_TYPE_VALUE = "cmis:relationship";

    public static final String DEFAULT_ITEM_TYPE = "org.apache.chemistry.opencmis.tck.default.itemType";
    public static final String DEFAULT_ITEM_TYPE_VALUE = "cmis:item";

    public static final String DEFAULT_SECONDARY_TYPE = "org.apache.chemistry.opencmis.tck.default.secondaryType";
    public static final String DEFAULT_SECONDARY_TYPE_VALUE = "cmis:secondary";

    public static final String DEFAULT_TEST_FOLDER_PARENT = "org.apache.chemistry.opencmis.tck.default.testFolderParent";
    public static final String DEFAULT_TEST_FOLDER_PARENT_VALUE = "/";

    public static final String DEFAULT_ACL_PRINCIPAL = "org.apache.chemistry.opencmis.tck.default.principal";
    public static final String DEFAULT_ACL_PRINCIPAL_VALUE = "cmis:user";

    private TestParameters() {
    }
}
