/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.endpoints;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.endpoints.CmisEndpointsDocument;
import org.apache.chemistry.opencmis.commons.impl.endpoints.CmisEndpointsDocumentHelper;
import org.apache.chemistry.opencmis.commons.impl.json.parser.JSONParseException;

public abstract class AbstractCmisEndpointsDocumentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CmisEndpointsDocument doc = this.getCmisEndpointsDocument(req, resp);
        if (doc == null) {
            resp.sendError(404, "CMIS Endpoints Document is not available!");
            return;
        }
        resp.setContentType("application/json; charset=UTF-8");
        PrintWriter pw = resp.getWriter();
        CmisEndpointsDocumentHelper.write((CmisEndpointsDocument)doc, (Writer)pw);
    }

    public abstract CmisEndpointsDocument getCmisEndpointsDocument(HttpServletRequest var1, HttpServletResponse var2) throws ServletException;

    public CmisEndpointsDocument readCmisEndpointsDocument(URL url) throws IOException, JSONParseException {
        return CmisEndpointsDocumentHelper.read((URL)url);
    }

    public CmisEndpointsDocument readCmisEndpointsDocument(File file) throws IOException, JSONParseException {
        return CmisEndpointsDocumentHelper.read((File)file);
    }

    public CmisEndpointsDocument readCmisEndpointsDocument(InputStream in) throws IOException, JSONParseException {
        return CmisEndpointsDocumentHelper.read((InputStream)in);
    }

    public CmisEndpointsDocument readCmisEndpointsDocument(Reader in) throws IOException, JSONParseException {
        return CmisEndpointsDocumentHelper.read((Reader)in);
    }

    public CmisEndpointsDocument readCmisEndpointsDocument(String in) throws JSONParseException {
        return CmisEndpointsDocumentHelper.read((String)in);
    }
}

