/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.browser;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.AbstractBrowserBindingService;
import org.apache.chemistry.opencmis.client.bindings.spi.browser.FormDataWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.http.HttpUtils;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.impl.JSONConverter;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AccessControlListImpl;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.apache.chemistry.opencmis.commons.spi.ExtendedAclService;

public class AclServiceImpl
extends AbstractBrowserBindingService
implements AclService,
ExtendedAclService {
    public AclServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId, "acl");
        url.addParameter("onlyBasicPermissions", (Object)onlyBasicPermissions);
        HttpUtils.Response resp = this.read(url);
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertAcl(json, null);
    }

    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        UrlBuilder url = this.getObjectUrl(repositoryId, objectId);
        final FormDataWriter formData = new FormDataWriter("applyACL");
        formData.addAddAcesParameters(addAces);
        formData.addRemoveAcesParameters(removeAces);
        formData.addParameter("ACLPropagation", aclPropagation);
        HttpUtils.Response resp = this.post(url, formData.getContentType(), new HttpUtils.Output(){

            public void write(OutputStream out) throws Exception {
                formData.write(out);
            }
        });
        Map<String, Object> json = this.parseObject(resp.getStream(), resp.getCharset());
        return JSONConverter.convertAcl(json, null);
    }

    public Acl setAcl(String repositoryId, String objectId, Acl aces) {
        Acl currentAcl = this.getAcl(repositoryId, objectId, false, null);
        ArrayList<Ace> removeAces = new ArrayList<Ace>();
        if (currentAcl.getAces() != null) {
            for (Ace ace : currentAcl.getAces()) {
                if (!ace.isDirect()) continue;
                removeAces.add(ace);
            }
        }
        return this.applyAcl(repositoryId, objectId, aces, (Acl)new AccessControlListImpl(removeAces), AclPropagation.OBJECTONLY, null);
    }
}

