/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport.config;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.tools.dbimport.config.ExcludeColumn;
import org.apache.cayenne.tools.dbimport.config.IncludeColumn;
import org.apache.cayenne.tools.dbimport.config.PatternParam;
import org.apache.commons.lang.StringUtils;

public class IncludeTable
extends PatternParam {
    private Collection<IncludeColumn> includeColumns = new LinkedList<IncludeColumn>();
    private Collection<ExcludeColumn> excludeColumns = new LinkedList<ExcludeColumn>();

    public IncludeTable() {
    }

    public IncludeTable(String pattern) {
        super(pattern);
    }

    public Collection<IncludeColumn> getIncludeColumns() {
        return this.includeColumns;
    }

    public void setIncludeColumns(Collection<IncludeColumn> includeColumns) {
        this.includeColumns = includeColumns;
    }

    public Collection<ExcludeColumn> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(Collection<ExcludeColumn> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public void addIncludeColumn(IncludeColumn includeColumn) {
        this.includeColumns.add(includeColumn);
    }

    public void addExcludeColumn(ExcludeColumn excludeColumn) {
        this.excludeColumns.add(excludeColumn);
    }

    @Override
    public String toString() {
        String str = "+(" + this.getPattern() + ") ";
        if (this.includeColumns != null && !this.includeColumns.isEmpty()) {
            str = str + "+Columns(" + StringUtils.join(this.includeColumns, (String)", ") + ") ";
        }
        if (this.excludeColumns != null && !this.excludeColumns.isEmpty()) {
            str = str + "-Columns(" + StringUtils.join(this.excludeColumns, (String)", ") + ") ";
        }
        return str;
    }
}

