/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport.config;

import org.apache.cayenne.access.loader.mapper.DbType;
import org.apache.cayenne.access.loader.mapper.DefaultJdbc2JavaTypeMapper;
import org.apache.cayenne.access.loader.mapper.Jdbc2JavaTypeMapper;
import org.apache.cayenne.tools.dbimport.config.Type;
import org.apache.cayenne.tools.dbimport.config.TypeMapper;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;

public class DefaultTypeMapperBuilder {
    private final DefaultJdbc2JavaTypeMapper mapper;
    private final Log logger;

    public DefaultTypeMapperBuilder(Log logger, TypeMapper typeMapper) {
        this.logger = logger;
        this.mapper = this.createMapper(typeMapper.getMapperClassName());
        for (Type type : typeMapper.getTypes()) {
            this.mapper.add(this.buildType(type), type.getJava());
        }
    }

    private DbType buildType(Type type) {
        return new DbType(type.getJdbc(), type.getLength(), type.getPrecision(), type.getScale(), type.getNotNull());
    }

    private DefaultJdbc2JavaTypeMapper createMapper(String className) {
        if (!StringUtils.isBlank((String)className)) {
            try {
                return (DefaultJdbc2JavaTypeMapper)ClassUtils.getClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)className).newInstance();
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)("Can't load class '" + className + "': "), (Throwable)e);
            }
            catch (InstantiationException e) {
                this.logger.error((Object)("Can't instantiate '" + className + "' make sure it has default constructor."), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.logger.error((Object)("Can't instantiate '" + className + "' make sure it has default constructor."), (Throwable)e);
            }
        }
        return new DefaultJdbc2JavaTypeMapper();
    }

    public DefaultTypeMapperBuilder setUsePrimitives(Boolean usePrimitives) {
        this.mapper.setUsePrimitives(usePrimitives);
        return this;
    }

    public Jdbc2JavaTypeMapper build() {
        return this.mapper;
    }
}

