/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport.config;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.resource.Resource;
import org.apache.cayenne.tools.ExcludeTable;
import org.apache.cayenne.tools.dbimport.config.Catalog;
import org.apache.cayenne.tools.dbimport.config.ExcludeColumn;
import org.apache.cayenne.tools.dbimport.config.ExcludeProcedure;
import org.apache.cayenne.tools.dbimport.config.IncludeColumn;
import org.apache.cayenne.tools.dbimport.config.IncludeProcedure;
import org.apache.cayenne.tools.dbimport.config.IncludeTable;
import org.apache.cayenne.tools.dbimport.config.PatternParam;
import org.apache.cayenne.tools.dbimport.config.ReverseEngineering;
import org.apache.cayenne.tools.dbimport.config.ReverseEngineeringLoader;
import org.apache.cayenne.tools.dbimport.config.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultReverseEngineeringLoader
implements ReverseEngineeringLoader {
    private static final Log LOG = LogFactory.getLog(ReverseEngineeringLoader.class);

    @Override
    public ReverseEngineering load(Resource configurationResource) throws CayenneRuntimeException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(configurationResource.getURL().openStream());
            ReverseEngineering engineering = new ReverseEngineering();
            Element root = doc.getDocumentElement();
            engineering.setSkipRelationshipsLoading(this.loadBoolean(root, "skipRelationshipsLoading"));
            engineering.setSkipPrimaryKeyLoading(this.loadBoolean(root, "skipPrimaryKeyLoading"));
            engineering.setTableTypes(this.loadTableTypes(root));
            engineering.setCatalogs(this.loadCatalogs(root));
            engineering.setSchemas(this.loadSchemas(root));
            engineering.setIncludeTables(this.loadIncludeTables(root));
            engineering.setExcludeTables(this.loadExcludeTables(root));
            engineering.setIncludeColumns(this.loadIncludeColumns(root));
            engineering.setExcludeColumns(this.loadExcludeColumns(root));
            engineering.setIncludeProcedures(this.loadIncludeProcedures(root));
            engineering.setExcludeProcedures(this.loadExcludeProcedures(root));
            return engineering;
        }
        catch (ParserConfigurationException e) {
            LOG.info((Object)e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            LOG.info((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOG.info((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Boolean loadBoolean(Element root, String name) {
        return Boolean.valueOf(this.loadByName(root, name));
    }

    private Collection<ExcludeProcedure> loadExcludeProcedures(Node parent) {
        return this.loadPatternParams(ExcludeProcedure.class, this.getElementsByTagName(parent, "excludeProcedure"));
    }

    private Collection<IncludeProcedure> loadIncludeProcedures(Node parent) {
        return this.loadPatternParams(IncludeProcedure.class, this.getElementsByTagName(parent, "includeProcedure"));
    }

    private Collection<ExcludeColumn> loadExcludeColumns(Node parent) {
        return this.loadPatternParams(ExcludeColumn.class, this.getElementsByTagName(parent, "excludeColumn"));
    }

    private Collection<IncludeColumn> loadIncludeColumns(Node parent) {
        return this.loadPatternParams(IncludeColumn.class, this.getElementsByTagName(parent, "includeColumn"));
    }

    private Collection<ExcludeTable> loadExcludeTables(Node parent) {
        return this.loadPatternParams(ExcludeTable.class, this.getElementsByTagName(parent, "excludeTable"));
    }

    private Collection<IncludeTable> loadIncludeTables(Node parent) {
        List<Node> includeTables = this.getElementsByTagName(parent, "includeTable");
        LinkedList<IncludeTable> res = new LinkedList<IncludeTable>();
        for (Node node : includeTables) {
            IncludeTable includeTable = new IncludeTable();
            includeTable.setPattern(this.loadPattern(node));
            includeTable.setIncludeColumns(this.loadIncludeColumns(node));
            includeTable.setExcludeColumns(this.loadExcludeColumns(node));
            res.add(includeTable);
        }
        return res;
    }

    private Collection<Schema> loadSchemas(Node parent) {
        List<Node> schemas = this.getElementsByTagName(parent, "schema");
        LinkedList<Schema> res = new LinkedList<Schema>();
        for (Node schemaNode : schemas) {
            Schema schema = new Schema();
            schema.setName(this.loadName(schemaNode));
            schema.setIncludeTables(this.loadIncludeTables(schemaNode));
            schema.setExcludeTables(this.loadExcludeTables(schemaNode));
            schema.setIncludeColumns(this.loadIncludeColumns(schemaNode));
            schema.setExcludeColumns(this.loadExcludeColumns(schemaNode));
            schema.setIncludeProcedures(this.loadIncludeProcedures(schemaNode));
            schema.setExcludeProcedures(this.loadExcludeProcedures(schemaNode));
            res.add(schema);
        }
        return res;
    }

    private Collection<Catalog> loadCatalogs(Node parent) {
        List<Node> catalogs = this.getElementsByTagName(parent, "catalog");
        LinkedList<Catalog> res = new LinkedList<Catalog>();
        for (Node catalogNode : catalogs) {
            Catalog catalog = new Catalog();
            catalog.setName(this.loadName(catalogNode));
            catalog.setSchemas(this.loadSchemas(catalogNode));
            catalog.setIncludeTables(this.loadIncludeTables(catalogNode));
            catalog.setExcludeTables(this.loadExcludeTables(catalogNode));
            catalog.setIncludeColumns(this.loadIncludeColumns(catalogNode));
            catalog.setExcludeColumns(this.loadExcludeColumns(catalogNode));
            catalog.setIncludeProcedures(this.loadIncludeProcedures(catalogNode));
            catalog.setExcludeProcedures(this.loadExcludeProcedures(catalogNode));
            res.add(catalog);
        }
        return res;
    }

    private Collection<String> loadTableTypes(Node parent) {
        List<Node> types = this.getElementsByTagName(parent, "tableType");
        LinkedList<String> res = new LinkedList<String>();
        for (Node typeNode : types) {
            res.add(this.loadName(typeNode));
        }
        return res;
    }

    private String loadName(Node catalogNode) {
        return this.loadByName(catalogNode, "name");
    }

    private String loadPattern(Node catalogNode) {
        return this.loadByName(catalogNode, "pattern");
    }

    private String loadByName(Node node, String attrName) {
        Node name = node.getAttributes().getNamedItem(attrName);
        if (name != null) {
            return name.getTextContent();
        }
        String content = node.getTextContent().trim();
        if (!content.isEmpty()) {
            return content;
        }
        List<Node> names = this.getElementsByTagName(node, attrName);
        if (names.isEmpty()) {
            return null;
        }
        return names.get(0).getTextContent();
    }

    private <T extends PatternParam> Collection<T> loadPatternParams(Class<T> clazz, List<Node> nodes) {
        LinkedList<PatternParam> res = new LinkedList<PatternParam>();
        for (Node node : nodes) {
            try {
                PatternParam obj = (PatternParam)clazz.newInstance();
                obj.setPattern(this.loadPattern(node));
                res.add(obj);
            }
            catch (InstantiationException e) {
                LOG.info((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        return res;
    }

    private List<Node> getElementsByTagName(Node catalogNode, String name) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        NodeList childNodes = catalogNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!name.equals(item.getNodeName())) continue;
            nodes.add(item);
        }
        return nodes;
    }
}

