/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport.config;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.cayenne.tools.dbimport.config.AntNestedElement;
import org.apache.cayenne.tools.dbimport.config.FilterContainer;
import org.apache.cayenne.tools.dbimport.config.Schema;

public class Catalog
extends FilterContainer {
    private String name;
    private Collection<Schema> schemas = new LinkedList<Schema>();

    public Catalog() {
    }

    public Catalog(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<Schema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(Collection<Schema> schemas) {
        this.schemas = schemas;
    }

    public void addSchema(Schema schema) {
        this.schemas.add(schema);
    }

    public void set(String name) {
        this.setName(name);
    }

    public void addConfiguredName(AntNestedElement name) {
        this.setName(name.getName());
    }

    public void addText(String name) {
        if (name.trim().isEmpty()) {
            return;
        }
        this.setName(name);
    }

    public Catalog schema(Schema name) {
        this.addSchema(name);
        return this;
    }

    @Override
    public boolean isEmptyContainer() {
        if (!super.isEmptyContainer()) {
            return false;
        }
        if (this.schemas.isEmpty()) {
            return true;
        }
        for (Schema schema : this.schemas) {
            if (schema.isEmptyContainer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.toString("    ");
    }

    @Override
    public String toString(String indent) {
        return indent + "Catalog '" + this.name + "': " + super.toString(indent + "    ");
    }
}

