/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import org.apache.cayenne.access.loader.filters.EntityFilters;
import org.apache.cayenne.access.loader.filters.FilterFactory;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.map.naming.DefaultNameGenerator;
import org.apache.cayenne.tools.AntLogger;
import org.apache.cayenne.tools.ExcludeTable;
import org.apache.cayenne.tools.configuration.ToolsModule;
import org.apache.cayenne.tools.dbimport.DbImportAction;
import org.apache.cayenne.tools.dbimport.DbImportConfiguration;
import org.apache.cayenne.tools.dbimport.DbImportModule;
import org.apache.cayenne.tools.dbimport.config.AntNestedElement;
import org.apache.cayenne.tools.dbimport.config.Catalog;
import org.apache.cayenne.tools.dbimport.config.ExcludeColumn;
import org.apache.cayenne.tools.dbimport.config.ExcludeProcedure;
import org.apache.cayenne.tools.dbimport.config.FiltersConfigBuilder;
import org.apache.cayenne.tools.dbimport.config.IncludeColumn;
import org.apache.cayenne.tools.dbimport.config.IncludeProcedure;
import org.apache.cayenne.tools.dbimport.config.IncludeTable;
import org.apache.cayenne.tools.dbimport.config.ReverseEngineering;
import org.apache.cayenne.tools.dbimport.config.Schema;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DbImporterTask
extends Task {
    private final DbImportConfiguration config;
    private final ReverseEngineering reverseEngineering = new ReverseEngineering();
    private final EntityFilters.Builder filterBuilder = new EntityFilters.Builder();

    public DbImporterTask() {
        this.config = new DbImportConfiguration();
        this.config.setOverwrite(true);
        this.config.setUsePrimitives(true);
        this.config.setNamingStrategy(DefaultNameGenerator.class.getName());
    }

    public void execute() {
        this.config.setFiltersConfig(new FiltersConfigBuilder(this.reverseEngineering).add(this.filterBuilder.build()).filtersConfig());
        this.validateAttributes();
        AntLogger logger = new AntLogger(this);
        this.config.setLogger(logger);
        this.config.setSkipRelationshipsLoading(this.reverseEngineering.getSkipRelationshipsLoading());
        this.config.setSkipPrimaryKeyLoading(this.reverseEngineering.getSkipPrimaryKeyLoading());
        this.config.setTableTypes(this.reverseEngineering.getTableTypes());
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{new ToolsModule(logger), new DbImportModule()});
        try {
            ((DbImportAction)injector.getInstance(DbImportAction.class)).execute(this.config);
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            String message = "Error importing database schema";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            this.log(message, 0);
            throw new BuildException(message, th);
        }
        finally {
            injector.shutdown();
        }
    }

    protected void validateAttributes() throws BuildException {
        DataSourceInfo dataSourceInfo;
        StringBuilder error = new StringBuilder("");
        if (this.config.getDataMapFile() == null) {
            error.append("The 'map' attribute must be set.\n");
        }
        if ((dataSourceInfo = this.config.getDataSourceInfo()).getJdbcDriver() == null) {
            error.append("The 'driver' attribute must be set.\n");
        }
        if (dataSourceInfo.getDataSourceUrl() == null) {
            error.append("The 'url' attribute must be set.\n");
        }
        if (error.length() > 0) {
            throw new BuildException(error.toString());
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.config.setOverwrite(overwrite);
    }

    @Deprecated
    public void setSchemaName(String schemaName) {
        this.setSchema(schemaName);
    }

    public void setSchema(String schema) {
        this.filterBuilder.schema(schema);
    }

    public void setDefaultPackage(String defaultPackage) {
        this.config.setDefaultPackage(defaultPackage);
    }

    public void setTablePattern(String tablePattern) {
        this.filterBuilder.includeTables(tablePattern);
    }

    public void setImportProcedures(boolean importProcedures) {
        this.filterBuilder.setProceduresFilters(importProcedures ? FilterFactory.TRUE : FilterFactory.NULL);
    }

    public void setProcedurePattern(String procedurePattern) {
        this.filterBuilder.includeProcedures(procedurePattern);
    }

    public void setMeaningfulPk(boolean meaningfulPk) {
        this.log("'meaningfulPk' property is deprecated. Use 'meaningfulPkTables' pattern instead", 1);
        if (meaningfulPk) {
            this.setMeaningfulPkTables("*");
        }
    }

    public void setMeaningfulPkTables(String meaningfulPkTables) {
        this.config.setMeaningfulPkTables(meaningfulPkTables);
    }

    public void setNamingStrategy(String namingStrategy) {
        this.config.setNamingStrategy(namingStrategy);
    }

    public void setAdapter(String adapter) {
        this.config.setAdapter(adapter);
    }

    public void setDriver(String driver) {
        this.config.setDriver(driver);
    }

    public void setMap(File map) {
        this.config.setDataMapFile(map);
    }

    public void setPassword(String password) {
        this.config.setPassword(password);
    }

    public void setUrl(String url) {
        this.config.setUrl(url);
    }

    public void setUserName(String username) {
        this.config.setUsername(username);
    }

    public void setIncludeTables(String includeTables) {
        this.filterBuilder.includeTables(includeTables);
    }

    public void setExcludeTables(String excludeTables) {
        this.filterBuilder.excludeTables(excludeTables);
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.config.setUsePrimitives(usePrimitives);
    }

    public void setSkipRelationshipsLoading(Boolean skipRelationshipsLoading) {
        this.reverseEngineering.setSkipRelationshipsLoading(skipRelationshipsLoading);
    }

    public void addConfiguredIncludeColumn(IncludeColumn includeColumn) {
        this.reverseEngineering.addIncludeColumn(includeColumn);
    }

    public void addConfiguredExcludeColumn(ExcludeColumn excludeColumn) {
        this.reverseEngineering.addExcludeColumn(excludeColumn);
    }

    public void addConfiguredIncludeTable(IncludeTable includeTable) {
        this.reverseEngineering.addIncludeTable(includeTable);
    }

    public void addConfiguredExcludeTable(ExcludeTable excludeTable) {
        this.reverseEngineering.addExcludeTable(excludeTable);
    }

    public void addConfiguredIncludeProcedure(IncludeProcedure includeProcedure) {
        this.reverseEngineering.addIncludeProcedure(includeProcedure);
    }

    public void addConfiguredExcludeProcedure(ExcludeProcedure excludeProcedure) {
        this.reverseEngineering.addExcludeProcedure(excludeProcedure);
    }

    public void addConfiguredSchema(Schema schema) {
        this.reverseEngineering.addSchema(schema);
    }

    public void addConfiguredCatalog(Catalog catalog) {
        this.reverseEngineering.addCatalog(catalog);
    }

    public void addConfiguredTableType(AntNestedElement type) {
        this.reverseEngineering.addTableType(type.getName());
    }

    public ReverseEngineering getReverseEngineering() {
        return this.reverseEngineering;
    }

    public File getMap() {
        return this.config.getDataMapFile();
    }

    public DbImportConfiguration toParameters() {
        return this.config;
    }
}

