/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map.naming;

import java.util.Locale;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.naming.ExportedKey;
import org.apache.cayenne.map.naming.NameConverter;
import org.apache.cayenne.map.naming.ObjectNameGenerator;
import org.jvnet.inflector.Noun;

public class DefaultNameGenerator
implements ObjectNameGenerator {
    public String createDbRelationshipName(ExportedKey key, boolean toMany) {
        String name;
        if (toMany) {
            try {
                name = Noun.pluralOf((String)key.getFKTableName().toLowerCase(), (Locale)Locale.ENGLISH).toUpperCase();
            }
            catch (Exception inflectorError) {
                return key.getFKTableName().toLowerCase();
            }
        } else {
            String fkColName = key.getFKColumnName();
            name = fkColName == null ? key.getPKTableName() : (fkColName.toUpperCase().endsWith("_ID") && fkColName.length() > 3 ? fkColName.substring(0, fkColName.length() - 3) : (fkColName.toUpperCase().endsWith("ID") && fkColName.length() > 2 ? fkColName.substring(0, fkColName.length() - 2) : key.getPKTableName()));
        }
        return NameConverter.underscoredToJava((String)name, (boolean)false);
    }

    public String createObjEntityName(DbEntity dbEntity) {
        return NameConverter.underscoredToJava((String)dbEntity.getName(), (boolean)true);
    }

    public String createObjAttributeName(DbAttribute attr) {
        return NameConverter.underscoredToJava((String)attr.getName(), (boolean)false);
    }

    public String createObjRelationshipName(DbRelationship dbRel) {
        return NameConverter.underscoredToJava((String)dbRel.getName(), (boolean)false);
    }
}

