/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.dbimport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.access.DbLoaderDelegate;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DbImportDbLoaderDelegate
implements DbLoaderDelegate {
    private List<DbEntity> addedDbEntities = new ArrayList<DbEntity>();
    private List<DbEntity> removedDbEntities = new ArrayList<DbEntity>();
    private List<ObjEntity> addedObjEntities = new ArrayList<ObjEntity>();
    private List<ObjEntity> removedObjEntities = new ArrayList<ObjEntity>();

    DbImportDbLoaderDelegate() {
    }

    public boolean overwriteDbEntity(DbEntity ent) throws CayenneException {
        return false;
    }

    public void dbEntityAdded(DbEntity ent) {
        ent.getDataMap().addDbEntity(ent);
        this.addedDbEntities.add(ent);
    }

    public void dbEntityRemoved(DbEntity ent) {
        ent.getDataMap().removeDbEntity(ent.getName());
        this.removedDbEntities.add(ent);
    }

    public void objEntityAdded(ObjEntity ent) {
        ent.getDataMap().addObjEntity(ent);
        this.addedObjEntities.add(ent);
    }

    public void objEntityRemoved(ObjEntity ent) {
        ent.getDataMap().removeObjEntity(ent.getName());
        this.removedObjEntities.add(ent);
    }

    public List<DbEntity> getAddedDbEntities() {
        return Collections.unmodifiableList(this.addedDbEntities);
    }

    public List<DbEntity> getRemovedDbEntities() {
        return Collections.unmodifiableList(this.removedDbEntities);
    }

    public List<ObjEntity> getAddedObjEntities() {
        return Collections.unmodifiableList(this.addedObjEntities);
    }

    public List<ObjEntity> getRemovedObjEntities() {
        return Collections.unmodifiableList(this.removedObjEntities);
    }
}

