/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools.configuration;

import org.apache.cayenne.access.jdbc.BatchQueryBuilderFactory;
import org.apache.cayenne.access.jdbc.DefaultBatchQueryBuilderFactory;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.DbAdapterFactory;
import org.apache.cayenne.configuration.server.DefaultDbAdapterFactory;
import org.apache.cayenne.dba.db2.DB2Sniffer;
import org.apache.cayenne.dba.derby.DerbySniffer;
import org.apache.cayenne.dba.frontbase.FrontBaseSniffer;
import org.apache.cayenne.dba.h2.H2Sniffer;
import org.apache.cayenne.dba.hsqldb.HSQLDBSniffer;
import org.apache.cayenne.dba.ingres.IngresSniffer;
import org.apache.cayenne.dba.mysql.MySQLSniffer;
import org.apache.cayenne.dba.openbase.OpenBaseSniffer;
import org.apache.cayenne.dba.oracle.OracleSniffer;
import org.apache.cayenne.dba.postgres.PostgresSniffer;
import org.apache.cayenne.dba.sqlite.SQLiteSniffer;
import org.apache.cayenne.dba.sqlserver.SQLServerSniffer;
import org.apache.cayenne.dba.sybase.SybaseSniffer;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.DefaultAdhocObjectFactory;
import org.apache.cayenne.log.CommonsJdbcEventLogger;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.tools.configuration.DriverDataSourceFactory;
import org.apache.commons.logging.Log;

public class ToolsModule
implements Module {
    private Log logger;

    public ToolsModule(Log logger) {
        if (logger == null) {
            throw new NullPointerException("Null logger");
        }
        this.logger = logger;
    }

    public void configure(Binder binder) {
        binder.bind(Log.class).toInstance((Object)this.logger);
        binder.bindMap("cayenne.properties");
        binder.bindList("cayenne.server.default_types");
        binder.bindList("cayenne.server.user_types");
        binder.bindList("cayenne.server.type_factories");
        DefaultAdhocObjectFactory objectFactory = new DefaultAdhocObjectFactory();
        binder.bind(AdhocObjectFactory.class).toInstance((Object)objectFactory);
        binder.bind(RuntimeProperties.class).to(DefaultRuntimeProperties.class);
        binder.bind(BatchQueryBuilderFactory.class).to(DefaultBatchQueryBuilderFactory.class);
        binder.bind(JdbcEventLogger.class).to(CommonsJdbcEventLogger.class);
        binder.bindList("cayenne.server.adapter_detectors").add((Object)new OpenBaseSniffer((AdhocObjectFactory)objectFactory)).add((Object)new FrontBaseSniffer((AdhocObjectFactory)objectFactory)).add((Object)new IngresSniffer((AdhocObjectFactory)objectFactory)).add((Object)new SQLiteSniffer((AdhocObjectFactory)objectFactory)).add((Object)new DB2Sniffer((AdhocObjectFactory)objectFactory)).add((Object)new H2Sniffer((AdhocObjectFactory)objectFactory)).add((Object)new HSQLDBSniffer((AdhocObjectFactory)objectFactory)).add((Object)new SybaseSniffer((AdhocObjectFactory)objectFactory)).add((Object)new DerbySniffer((AdhocObjectFactory)objectFactory)).add((Object)new SQLServerSniffer((AdhocObjectFactory)objectFactory)).add((Object)new OracleSniffer((AdhocObjectFactory)objectFactory)).add((Object)new PostgresSniffer((AdhocObjectFactory)objectFactory)).add((Object)new MySQLSniffer((AdhocObjectFactory)objectFactory));
        binder.bind(DbAdapterFactory.class).to(DefaultDbAdapterFactory.class);
        binder.bind(DataSourceFactory.class).to(DriverDataSourceFactory.class);
    }
}

