/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import org.apache.cayenne.di.DIBootstrap;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.map.naming.SmartNamingStrategy;
import org.apache.cayenne.tools.AntLogger;
import org.apache.cayenne.tools.configuration.ToolsModule;
import org.apache.cayenne.tools.dbimport.DbImportAction;
import org.apache.cayenne.tools.dbimport.DbImportModule;
import org.apache.cayenne.tools.dbimport.DbImportParameters;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class DbImporterTask
extends Task {
    private DbImportParameters parameters = new DbImportParameters();
    private String schemaName;
    private boolean meaningfulPk;

    public DbImporterTask() {
        this.parameters.setOverwrite(true);
        this.parameters.setImportProcedures(false);
        this.parameters.setUsePrimitives(true);
        this.parameters.setNamingStrategy(SmartNamingStrategy.class.getName());
    }

    public void execute() {
        this.initSchema();
        this.initMeaningfulPkTables();
        this.validateAttributes();
        AntLogger logger = new AntLogger(this);
        Injector injector = DIBootstrap.createInjector((Module[])new Module[]{new ToolsModule(logger), new DbImportModule()});
        try {
            ((DbImportAction)injector.getInstance(DbImportAction.class)).execute(this.parameters);
        }
        catch (Exception ex) {
            Throwable th = Util.unwindException((Throwable)ex);
            String message = "Error importing database schema";
            if (th.getLocalizedMessage() != null) {
                message = message + ": " + th.getLocalizedMessage();
            }
            this.log(message, 0);
            throw new BuildException(message, th);
        }
        finally {
            injector.shutdown();
        }
    }

    protected void validateAttributes() throws BuildException {
        StringBuilder error = new StringBuilder("");
        if (this.parameters.getDataMapFile() == null) {
            error.append("The 'map' attribute must be set.\n");
        }
        if (this.parameters.getDriver() == null) {
            error.append("The 'driver' attribute must be set.\n");
        }
        if (this.parameters.getUrl() == null) {
            error.append("The 'adapter' attribute must be set.\n");
        }
        if (error.length() > 0) {
            throw new BuildException(error.toString());
        }
    }

    public void setOverwrite(boolean overwrite) {
        this.parameters.setOverwrite(overwrite);
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setSchema(String schema) {
        this.parameters.setSchema(schema);
    }

    public void setDefaultPackage(String defaultPackage) {
        this.parameters.setDefaultPackage(defaultPackage);
    }

    public void setTablePattern(String tablePattern) {
        this.parameters.setTablePattern(tablePattern);
    }

    public void setImportProcedures(boolean importProcedures) {
        this.parameters.setImportProcedures(importProcedures);
    }

    public void setProcedurePattern(String procedurePattern) {
        this.parameters.setProcedurePattern(procedurePattern);
    }

    public void setMeaningfulPk(boolean meaningfulPk) {
        this.meaningfulPk = meaningfulPk;
    }

    public void setMeaningfulPkTables(String meaningfulPkTables) {
        this.parameters.setMeaningfulPkTables(meaningfulPkTables);
    }

    public void setNamingStrategy(String namingStrategy) {
        this.parameters.setNamingStrategy(namingStrategy);
    }

    public void setAdapter(String adapter) {
        this.parameters.setAdapter(adapter);
    }

    public void setDriver(String driver) {
        this.parameters.setDriver(driver);
    }

    public void setMap(File map) {
        this.parameters.setDataMapFile(map);
    }

    public void setPassword(String password) {
        this.parameters.setPassword(password);
    }

    public void setUrl(String url) {
        this.parameters.setUrl(url);
    }

    public void setUserName(String username) {
        this.parameters.setUsername(username);
    }

    public void setIncludeTables(String includeTables) {
        this.parameters.setIncludeTables(includeTables);
    }

    public void setExcludeTables(String excludeTables) {
        this.parameters.setExcludeTables(excludeTables);
    }

    public void setUsePrimitives(boolean usePrimitives) {
        this.parameters.setUsePrimitives(usePrimitives);
    }

    private void initSchema() {
        if (this.schemaName != null) {
            this.log("'schemaName' property is deprecated. Use 'schema' instead", 1);
        }
        if (this.parameters.getSchema() == null) {
            this.parameters.setSchema(this.schemaName);
        }
    }

    private void initMeaningfulPkTables() {
        if (this.meaningfulPk) {
            this.log("'meaningfulPk' property is deprecated. Use 'meaningfulPkTables' pattern instead", 1);
        }
        if (this.parameters.getMeaningfulPkTables() == null && this.meaningfulPk) {
            this.parameters.setMeaningfulPkTables("*");
        }
    }
}

