/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.tools;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataPort;
import org.apache.cayenne.access.DataPortDelegate;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.resource.FilesystemResourceLocator;
import org.apache.cayenne.resource.ResourceLocator;
import org.apache.cayenne.tools.AntDataPortDelegate;
import org.apache.cayenne.tools.CayenneTask;
import org.apache.cayenne.util.Util;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPortTask
extends CayenneTask {
    protected File projectFile;
    protected String maps;
    protected String srcNode;
    protected String destNode;
    protected String includeTables;
    protected String excludeTables;
    protected boolean cleanDest = true;

    public void execute() throws BuildException {
        DataDomain domain;
        this.validateParameters();
        String projectFileLocation = this.projectFile.getName();
        Module dataPortModule = new Module(){

            public void configure(Binder binder) {
                binder.bind(ResourceLocator.class).toInstance((Object)new FilesystemResourceLocator(new File[]{DataPortTask.this.projectFile}));
            }
        };
        ServerRuntime runtime = new ServerRuntime(projectFileLocation, new Module[]{dataPortModule});
        ClassLoader threadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            domain = runtime.getDataDomain();
        }
        catch (Exception ex) {
            throw new BuildException("Error loading Cayenne configuration from " + this.projectFile, (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadContextClassLoader);
        }
        DataNode source = domain.getNode(this.srcNode);
        if (source == null) {
            throw new BuildException("srcNode not found in the project: " + this.srcNode);
        }
        DataNode destination = domain.getNode(this.destNode);
        if (destination == null) {
            throw new BuildException("destNode not found in the project: " + this.destNode);
        }
        this.log("Porting from '" + this.srcNode + "' to '" + this.destNode + "'.");
        AntDataPortDelegate portDelegate = new AntDataPortDelegate(this, this.maps, this.includeTables, this.excludeTables);
        DataPort dataPort = new DataPort((DataPortDelegate)portDelegate);
        dataPort.setEntities(this.getAllEntities(source, destination));
        dataPort.setCleaningDestination(this.cleanDest);
        dataPort.setSourceNode(source);
        dataPort.setDestinationNode(destination);
        try {
            dataPort.execute();
        }
        catch (Exception e) {
            Throwable topOfStack = Util.unwindException((Throwable)e);
            throw new BuildException("Error porting data: " + topOfStack.getMessage(), topOfStack);
        }
    }

    protected Collection<DbEntity> getAllEntities(DataNode source, DataNode target) {
        HashSet<DbEntity> allEntities = new HashSet<DbEntity>();
        for (DataMap map : source.getDataMaps()) {
            allEntities.addAll(map.getDbEntities());
        }
        for (DataMap map : target.getDataMaps()) {
            allEntities.addAll(map.getDbEntities());
        }
        this.log("Number of entities: " + allEntities.size(), 3);
        if (allEntities.size() == 0) {
            this.log("No entities found for either source or target.");
        }
        return allEntities;
    }

    protected void validateParameters() throws BuildException {
        if (this.projectFile == null) {
            throw new BuildException("Required 'projectFile' parameter is missing.");
        }
        if (!this.projectFile.exists()) {
            throw new BuildException("'projectFile' does not exist: " + this.projectFile);
        }
        if (this.srcNode == null) {
            throw new BuildException("Required 'srcNode' parameter is missing.");
        }
        if (this.destNode == null) {
            throw new BuildException("Required 'destNode' parameter is missing.");
        }
    }

    public void setDestNode(String destNode) {
        this.destNode = destNode;
    }

    public void setExcludeTables(String excludeTables) {
        this.excludeTables = excludeTables;
    }

    public void setIncludeTables(String includeTables) {
        this.includeTables = includeTables;
    }

    public void setMaps(String maps) {
        this.maps = maps;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setSrcNode(String srcNode) {
        this.srcNode = srcNode;
    }

    public void setCleanDest(boolean flag) {
        this.cleanDest = flag;
    }
}

