/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import java.util.Collection;
import org.apache.cayenne.gen.ClassGenerationAction;
import org.apache.cayenne.gen.ClientDataMapArtifact;
import org.apache.cayenne.gen.ClientEntityArtifact;
import org.apache.cayenne.gen.TemplateType;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientClassGenerationAction
extends ClassGenerationAction {
    public static final String SUBCLASS_TEMPLATE = "dotemplates/v1_2/client-subclass.vm";
    public static final String SUPERCLASS_TEMPLATE = "dotemplates/v1_2/client-superclass.vm";
    public static final String DMAP_SINGLE_CLASS_TEMPLATE = "dotemplates/v1_2/client-datamap-singleclass.vm";
    public static final String DMAP_SUBCLASS_TEMPLATE = "dotemplates/v1_2/client-datamap-subclass.vm";
    public static final String DMAP_SUPERCLASS_TEMPLATE = "dotemplates/v1_2/client-datamap-superclass.vm";
    public static final String CLIENT_SUPERCLASS_PREFIX = "_Client";

    @Override
    protected String defaultTemplateName(TemplateType type) {
        switch (type) {
            case ENTITY_SUBCLASS: {
                return SUBCLASS_TEMPLATE;
            }
            case ENTITY_SUPERCLASS: {
                return SUPERCLASS_TEMPLATE;
            }
            case EMBEDDABLE_SUBCLASS: {
                return "dotemplates/v1_2/embeddable-subclass.vm";
            }
            case EMBEDDABLE_SUPERCLASS: {
                return "dotemplates/v1_2/embeddable-superclass.vm";
            }
            case DATAMAP_SUPERCLASS: {
                return DMAP_SUPERCLASS_TEMPLATE;
            }
            case DATAMAP_SUBCLASS: {
                return DMAP_SUBCLASS_TEMPLATE;
            }
        }
        throw new IllegalArgumentException("Unsupported template type: " + (Object)((Object)type));
    }

    @Override
    public void addEntities(Collection<ObjEntity> entities) {
        if (entities != null) {
            for (ObjEntity entity : entities) {
                this.artifacts.add(new ClientEntityArtifact(entity));
            }
        }
    }

    @Override
    public void addQueries(Collection<Query> queries) {
        if (queries != null) {
            this.artifacts.add(new ClientDataMapArtifact(this.dataMap, queries));
        }
    }
}

