/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.gen;

import foundrylogic.vpp.VPPConfig;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.PersistentObject;
import org.apache.cayenne.gen.ClassGenerationInfo;
import org.apache.cayenne.gen.ClassGenerator;
import org.apache.cayenne.gen.StringUtils;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.ObjEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapClassGenerator {
    public static final String SINGLE_CLASS_TEMPLATE_1_1 = "dotemplates/singleclass.vm";
    public static final String SUBCLASS_TEMPLATE_1_1 = "dotemplates/subclass.vm";
    public static final String SUPERCLASS_TEMPLATE_1_1 = "dotemplates/superclass.vm";
    public static final String SINGLE_CLASS_TEMPLATE_1_2 = "dotemplates/v1_2/singleclass.vm";
    public static final String SUBCLASS_TEMPLATE_1_2 = "dotemplates/v1_2/subclass.vm";
    public static final String SUPERCLASS_TEMPLATE_1_2 = "dotemplates/v1_2/superclass.vm";
    public static final String CLIENT_SUBCLASS_TEMPLATE_1_2 = "dotemplates/v1_2/client-subclass.vm";
    public static final String CLIENT_SUPERCLASS_TEMPLATE_1_2 = "dotemplates/v1_2/client-superclass.vm";
    public static final String SINGLE_CLASS_TEMPLATE = "dotemplates/singleclass.vm";
    public static final String SUBCLASS_TEMPLATE = "dotemplates/subclass.vm";
    public static final String SUPERCLASS_TEMPLATE = "dotemplates/superclass.vm";
    public static final String SUPERCLASS_PREFIX = "_";
    protected static final String VERSION_1_1 = "1.1";
    protected static final String VERSION_1_2 = "1.2";
    public static final String DEFAULT_VERSION = "1.2";
    public static final String MODE_DATAMAP = "datamap";
    public static final String MODE_ENTITY = "entity";
    protected String versionString = "1.2";
    protected List<ObjEntity> objEntities;
    protected String superPkg;
    protected DataMap dataMap;
    protected VPPConfig vppConfig;
    protected String mode = "entity";
    protected boolean client;

    public MapClassGenerator() {
    }

    public MapClassGenerator(DataMap dataMap) {
        this(dataMap, new ArrayList<ObjEntity>(dataMap.getObjEntities()));
    }

    public MapClassGenerator(DataMap dataMap, List<ObjEntity> objEntities) {
        this.dataMap = dataMap;
        this.setObjEntities(objEntities);
    }

    protected String defaultSingleClassTemplate() {
        if (this.client) {
            throw new IllegalStateException("Default generation for single classes on the client is not supported...");
        }
        if (VERSION_1_1.equals(this.versionString)) {
            return "dotemplates/singleclass.vm";
        }
        if ("1.2".equals(this.versionString)) {
            return SINGLE_CLASS_TEMPLATE_1_2;
        }
        return "dotemplates/singleclass.vm";
    }

    protected String defaultSubclassTemplate() {
        if (this.client) {
            return CLIENT_SUBCLASS_TEMPLATE_1_2;
        }
        if (VERSION_1_1.equals(this.versionString)) {
            return "dotemplates/subclass.vm";
        }
        if ("1.2".equals(this.versionString)) {
            return SUBCLASS_TEMPLATE_1_2;
        }
        return "dotemplates/subclass.vm";
    }

    protected String defaultSuperclassTemplate() {
        if (this.client) {
            return CLIENT_SUPERCLASS_TEMPLATE_1_2;
        }
        if (VERSION_1_1.equals(this.versionString)) {
            return "dotemplates/superclass.vm";
        }
        if ("1.2".equals(this.versionString)) {
            return SUPERCLASS_TEMPLATE_1_2;
        }
        return "dotemplates/superclass.vm";
    }

    public abstract Writer openWriter(ObjEntity var1, String var2, String var3) throws Exception;

    public abstract void closeWriter(Writer var1) throws Exception;

    public void generateClassPairs() throws Exception {
        this.generateClassPairs(this.defaultSubclassTemplate(), this.defaultSuperclassTemplate(), SUPERCLASS_PREFIX);
    }

    public void generateClassPairs(String classTemplate, String superTemplate, String superPrefix) throws Exception {
        if (this.client) {
            this.generateClientClassPairs_1_2(classTemplate, superTemplate, superPrefix);
        } else if (VERSION_1_1.equals(this.versionString)) {
            this.generateClassPairs_1_1(classTemplate, superTemplate, superPrefix);
        } else if ("1.2".equals(this.versionString)) {
            this.generateClassPairs_1_2(classTemplate, superTemplate, superPrefix);
        } else {
            throw new IllegalStateException("Illegal Version in generateClassPairs: " + this.versionString);
        }
    }

    private void generateClassPairs_1_1(String classTemplate, String superTemplate, String superPrefix) throws Exception {
        ClassGenerator mainGenSetup = new ClassGenerator(classTemplate, this.versionString);
        ClassGenerator superGenSetup = new ClassGenerator(superTemplate, this.versionString);
        ClassGenerationInfo mainGen = mainGenSetup.getClassGenerationInfo();
        ClassGenerationInfo superGen = superGenSetup.getClassGenerationInfo();
        mainGen.setSuperPrefix(superPrefix);
        superGen.setSuperPrefix(superPrefix);
        for (ObjEntity ent : this.entitiesForCurrentMode()) {
            this.initClassGenerator_1_1(superGen, ent, true);
            Writer superOut = this.openWriter(ent, superGen.getPackageName(), superPrefix + superGen.getClassName());
            if (superOut != null) {
                superGenSetup.generateClass(superOut, ent);
                this.closeWriter(superOut);
            }
            this.initClassGenerator_1_1(mainGen, ent, false);
            Writer mainOut = this.openWriter(ent, mainGen.getPackageName(), mainGen.getClassName());
            if (mainOut == null) continue;
            mainGenSetup.generateClass(mainOut, ent);
            this.closeWriter(mainOut);
        }
    }

    private void generateClientClassPairs_1_2(String classTemplate, String superTemplate, String superPrefix) throws Exception {
        ClassGenerator mainGenSetup = new ClassGenerator(classTemplate, "1.2", this.vppConfig);
        ClassGenerator superGenSetup = new ClassGenerator(superTemplate, "1.2", this.vppConfig);
        for (ObjEntity entity : this.entitiesForCurrentMode()) {
            Writer mainOut;
            String fqnSubClass = entity.getClientClassName();
            if (fqnSubClass == null) {
                fqnSubClass = entity.getClassName();
            }
            String fqnBaseClass = entity.getClientSuperClassName() != null ? entity.getClientSuperClassName() : PersistentObject.class.getName();
            StringUtils stringUtils = StringUtils.getInstance();
            String subClassName = stringUtils.stripPackageName(fqnSubClass);
            String subPackageName = stringUtils.stripClass(fqnSubClass);
            String superClassName = superPrefix + stringUtils.stripPackageName(fqnSubClass);
            String superPackageName = this.superPkg;
            String fqnSuperClass = superPackageName + "." + superClassName;
            Writer superOut = this.openWriter(entity, superPackageName, superClassName);
            if (superOut != null) {
                superGenSetup.generateClass(superOut, this.dataMap, entity, fqnBaseClass, fqnSuperClass, fqnSubClass);
                this.closeWriter(superOut);
            }
            if ((mainOut = this.openWriter(entity, subPackageName, subClassName)) == null) continue;
            mainGenSetup.generateClass(mainOut, this.dataMap, entity, fqnBaseClass, fqnSuperClass, fqnSubClass);
            this.closeWriter(mainOut);
        }
    }

    private void generateClassPairs_1_2(String classTemplate, String superTemplate, String superPrefix) throws Exception {
        ClassGenerator mainGenSetup = new ClassGenerator(classTemplate, this.versionString, this.vppConfig);
        ClassGenerator superGenSetup = new ClassGenerator(superTemplate, this.versionString, this.vppConfig);
        for (ObjEntity ent : this.entitiesForCurrentMode()) {
            Writer mainOut;
            String fqnSubClass = ent.getClassName();
            String fqnBaseClass = null != ent.getSuperClassName() ? ent.getSuperClassName() : CayenneDataObject.class.getName();
            StringUtils stringUtils = StringUtils.getInstance();
            String subClassName = stringUtils.stripPackageName(fqnSubClass);
            String subPackageName = stringUtils.stripClass(fqnSubClass);
            String superClassName = superPrefix + stringUtils.stripPackageName(fqnSubClass);
            String superPackageName = this.superPkg;
            String fqnSuperClass = superPackageName + "." + superClassName;
            Writer superOut = this.openWriter(ent, superPackageName, superClassName);
            if (superOut != null) {
                superGenSetup.generateClass(superOut, this.dataMap, ent, fqnBaseClass, fqnSuperClass, fqnSubClass);
                this.closeWriter(superOut);
            }
            if ((mainOut = this.openWriter(ent, subPackageName, subClassName)) == null) continue;
            mainGenSetup.generateClass(mainOut, this.dataMap, ent, fqnBaseClass, fqnSuperClass, fqnSubClass);
            this.closeWriter(mainOut);
        }
    }

    public void generateSingleClasses() throws Exception {
        this.generateSingleClasses(this.defaultSingleClassTemplate(), SUPERCLASS_PREFIX);
    }

    private void generateSingleClasses_1_1(String classTemplate) throws Exception {
        ClassGenerator gen = new ClassGenerator(classTemplate, this.versionString);
        for (ObjEntity ent : this.entitiesForCurrentMode()) {
            this.initClassGenerator_1_1(gen.getClassGenerationInfo(), ent, false);
            Writer out = this.openWriter(ent, gen.getClassGenerationInfo().getPackageName(), gen.getClassGenerationInfo().getClassName());
            if (out == null) continue;
            gen.generateClass(out, ent);
            this.closeWriter(out);
        }
    }

    private void generateSingleClasses_1_2(String classTemplate, String superPrefix) throws Exception {
        ClassGenerator gen = new ClassGenerator(classTemplate, this.versionString, this.vppConfig);
        for (ObjEntity ent : this.entitiesForCurrentMode()) {
            String fqnSubClass = ent.getClassName();
            String fqnBaseClass = null != ent.getSuperClassName() ? ent.getSuperClassName() : CayenneDataObject.class.getName();
            StringUtils stringUtils = StringUtils.getInstance();
            String subClassName = stringUtils.stripPackageName(fqnSubClass);
            String subPackageName = stringUtils.stripClass(fqnSubClass);
            String superClassName = superPrefix + stringUtils.stripPackageName(fqnSubClass);
            String superPackageName = this.superPkg;
            String fqnSuperClass = superPackageName + "." + superClassName;
            Writer out = this.openWriter(ent, subPackageName, subClassName);
            if (out == null) continue;
            gen.generateClass(out, this.dataMap, ent, fqnBaseClass, fqnSuperClass, fqnSubClass);
            this.closeWriter(out);
        }
    }

    private Collection<ObjEntity> entitiesForCurrentMode() {
        if (!MODE_ENTITY.equals(this.mode) && !this.objEntities.isEmpty()) {
            return Collections.singleton(this.objEntities.get(0));
        }
        return this.objEntities;
    }

    public void generateSingleClasses(String classTemplate, String superPrefix) throws Exception {
        if (this.client) {
            this.generateSingleClasses_1_2(classTemplate, superPrefix);
        } else if (VERSION_1_1.equals(this.versionString)) {
            this.generateSingleClasses_1_1(classTemplate);
        } else if ("1.2".equals(this.versionString)) {
            this.generateSingleClasses_1_2(classTemplate, superPrefix);
        } else {
            throw new IllegalStateException("Illegal Version in generateClassPairs: " + this.versionString);
        }
    }

    protected void initClassGenerator_1_1(ClassGenerationInfo gen, ObjEntity entity, boolean superclass) {
        String fullClassName = entity.getClassName();
        int i = fullClassName.lastIndexOf(".");
        String pkg = null;
        String spkg = null;
        String cname = null;
        if (i == 0 || i + 1 == fullClassName.length()) {
            throw new CayenneRuntimeException("Invalid class mapping: " + fullClassName);
        }
        if (i < 0) {
            pkg = superclass ? this.superPkg : null;
            spkg = superclass ? null : this.superPkg;
            cname = fullClassName;
        } else {
            cname = fullClassName.substring(i + 1);
            pkg = superclass && this.superPkg != null ? this.superPkg : fullClassName.substring(0, i);
            spkg = !superclass && this.superPkg != null && !pkg.equals(this.superPkg) ? this.superPkg : null;
        }
        gen.setPackageName(pkg);
        gen.setClassName(cname);
        if (entity.getSuperClassName() != null) {
            gen.setSuperClassName(entity.getSuperClassName());
        } else {
            gen.setSuperClassName(CayenneDataObject.class.getName());
        }
        gen.setSuperPackageName(spkg);
    }

    public String getSuperPkg() {
        return this.superPkg;
    }

    public void setSuperPkg(String superPkg) {
        this.superPkg = superPkg;
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public DataMap getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(DataMap dataMap) {
        this.dataMap = dataMap;
    }

    public List<ObjEntity> getObjEntities() {
        return this.objEntities;
    }

    public void setObjEntities(List<ObjEntity> objEntities) {
        this.objEntities = objEntities != null ? new ArrayList<ObjEntity>(objEntities) : new ArrayList();
        Iterator<ObjEntity> it = objEntities.iterator();
        while (it.hasNext()) {
            ObjEntity e = it.next();
            if (!e.isGeneric()) continue;
            it.remove();
        }
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setVersionString(String versionString) {
        if (!VERSION_1_1.equals(versionString) && !"1.2".equals(versionString)) {
            throw new IllegalStateException("'version' must be '1.1' or '1.2', but was '" + versionString + "'");
        }
        this.versionString = versionString;
    }

    public VPPConfig getVppConfig() {
        return this.vppConfig;
    }

    public void setVppConfig(VPPConfig vppConfig) {
        this.vppConfig = vppConfig;
    }

    public void setMode(String mode) {
        if (!MODE_ENTITY.equals(mode) && !MODE_DATAMAP.equals(mode)) {
            throw new IllegalStateException("'mode' must be 'entity' or 'datamap', but was '" + mode + "'");
        }
        this.mode = mode;
    }
}

