/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;

public abstract class FluentSelect<T, S extends FluentSelect<T, S>>
extends IndirectQuery
implements Select<T> {
    protected Class<?> entityType;
    protected String entityName;
    protected String dbEntityName;
    protected Expression where;
    protected Collection<Ordering> orderings;
    protected PrefetchTreeNode prefetches;
    protected int limit;
    protected int offset;
    protected int pageSize;
    protected int statementFetchSize;
    protected QueryCacheStrategy cacheStrategy;
    protected String cacheGroup;

    protected FluentSelect() {
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        SelectQuery replacement = new SelectQuery();
        if (this.entityType != null) {
            replacement.setRoot(this.entityType);
        } else if (this.entityName != null) {
            ObjEntity entity = resolver.getObjEntity(this.entityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized ObjEntity name: " + this.entityName, new Object[0]);
            }
            replacement.setRoot(entity);
        } else if (this.dbEntityName != null) {
            DbEntity entity = resolver.getDbEntity(this.dbEntityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized DbEntity name: " + this.dbEntityName, new Object[0]);
            }
            replacement.setRoot(entity);
        } else {
            throw new CayenneRuntimeException("Undefined root entity of the query", new Object[0]);
        }
        replacement.setName(this.name);
        replacement.setQualifier(this.where);
        replacement.addOrderings(this.orderings);
        replacement.setPrefetchTree(this.prefetches);
        replacement.setCacheStrategy(this.cacheStrategy);
        replacement.setCacheGroup(this.cacheGroup);
        replacement.setFetchLimit(this.limit);
        replacement.setFetchOffset(this.offset);
        replacement.setPageSize(this.pageSize);
        replacement.setStatementFetchSize(this.statementFetchSize);
        return replacement;
    }

    public S entityType(Class<?> entityType) {
        return this.resetEntity(entityType, null, null);
    }

    public S entityName(String entityName) {
        return this.resetEntity(null, entityName, null);
    }

    public S dbEntityName(String dbEntityName) {
        return this.resetEntity(null, null, dbEntityName);
    }

    private S resetEntity(Class<?> entityType, String entityName, String dbEntityName) {
        this.entityType = entityType;
        this.entityName = entityName;
        this.dbEntityName = dbEntityName;
        return (S)this;
    }

    public S where(Expression expression) {
        return this.and(expression);
    }

    public S where(String expressionString, Object ... parameters) {
        return this.and(ExpressionFactory.exp(expressionString, parameters));
    }

    public S and(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return (S)this;
        }
        return this.and(Arrays.asList(expressions));
    }

    public S and(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return (S)this;
        }
        if (this.where != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(this.where);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.where = ExpressionFactory.and(all);
        return (S)this;
    }

    public S or(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return (S)this;
        }
        return this.or(Arrays.asList(expressions));
    }

    public S or(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return (S)this;
        }
        if (this.where != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(this.where);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.where = ExpressionFactory.or(all);
        return (S)this;
    }

    public S orderBy(String property) {
        return this.orderBy(new Ordering(property));
    }

    public S orderBy(String property, SortOrder sortOrder) {
        return this.orderBy(new Ordering(property, sortOrder));
    }

    public S orderBy(Ordering ... orderings) {
        if (orderings == null) {
            return (S)this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>(orderings.length);
        }
        Collections.addAll(this.orderings, orderings);
        return (S)this;
    }

    public S orderBy(Collection<Ordering> orderings) {
        if (orderings == null) {
            return (S)this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>(orderings.size());
        }
        this.orderings.addAll(orderings);
        return (S)this;
    }

    public S prefetch(PrefetchTreeNode prefetch) {
        if (prefetch == null) {
            return (S)this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.merge(prefetch);
        return (S)this;
    }

    public S prefetch(String path, int semantics) {
        if (path == null) {
            return (S)this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.addPath(path).setSemantics(semantics);
        return (S)this;
    }

    public S limit(int fetchLimit) {
        if (this.limit != fetchLimit) {
            this.limit = fetchLimit;
            this.replacementQuery = null;
        }
        return (S)this;
    }

    public S offset(int fetchOffset) {
        if (this.offset != fetchOffset) {
            this.offset = fetchOffset;
            this.replacementQuery = null;
        }
        return (S)this;
    }

    public S pageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            this.pageSize = pageSize;
            this.replacementQuery = null;
        }
        return (S)this;
    }

    public S statementFetchSize(int size) {
        if (this.statementFetchSize != size) {
            this.statementFetchSize = size;
            this.replacementQuery = null;
        }
        return (S)this;
    }

    public S cacheStrategy(QueryCacheStrategy strategy) {
        if (this.cacheStrategy != strategy) {
            this.cacheStrategy = strategy;
            this.replacementQuery = null;
        }
        if (this.cacheGroup != null) {
            this.cacheGroup = null;
            this.replacementQuery = null;
        }
        return (S)this;
    }

    public S cacheStrategy(QueryCacheStrategy strategy, String cacheGroup) {
        return ((FluentSelect)this.cacheStrategy(strategy)).cacheGroup(cacheGroup);
    }

    public S cacheGroup(String cacheGroup) {
        this.cacheGroup = cacheGroup;
        this.replacementQuery = null;
        return (S)this;
    }

    public S localCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroup);
    }

    public S localCache() {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
    }

    public S sharedCache(String cacheGroup) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroup);
    }

    public S sharedCache() {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
    }

    public String getCacheGroup() {
        return this.cacheGroup;
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public Expression getWhere() {
        return this.where;
    }

    public Collection<Ordering> getOrderings() {
        return this.orderings;
    }

    public PrefetchTreeNode getPrefetches() {
        return this.prefetches;
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }
}

