/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.exp.parser.EvaluatedNode;

public abstract class ASTFunctionCall
extends EvaluatedNode {
    private String functionName;

    ASTFunctionCall(int id, String functionName) {
        super(id);
        this.functionName = functionName;
    }

    public ASTFunctionCall(int id, String functionName, Object ... nodes) {
        this(id, functionName);
        this.functionName = functionName;
        int len = nodes.length;
        for (int i = 0; i < len; ++i) {
            this.jjtAddChild(this.wrapChild(nodes[i]), i);
        }
        this.connectChildren();
    }

    @Override
    public int getType() {
        return 45;
    }

    public boolean needParenthesis() {
        return true;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    @Override
    protected String getExpressionOperator(int index) {
        return ",";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ASTFunctionCall that = (ASTFunctionCall)o;
        return this.functionName.equals(that.functionName);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.functionName.hashCode();
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        out.append(this.getFunctionName());
        if (this.parent == null) {
            out.append("(");
        }
        super.appendAsString(out);
        if (this.parent == null) {
            out.append(")");
        }
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        out.append(this.getFunctionName());
        out.append("(");
        super.appendChildrenAsEJBQL(parameterAccumulator, out, rootId);
        out.append(")");
    }
}

