/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sybase;

import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.exp.parser.ASTFunctionCall;

public class SybaseQualifierTranslator
extends QualifierTranslator {
    public SybaseQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler);
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": 
            case "CONCAT": {
                break;
            }
            case "LENGTH": {
                this.out.append("LEN");
                break;
            }
            case "LOCATE": {
                this.out.append("CHARINDEX");
                break;
            }
            default: {
                super.appendFunction(functionExpression);
            }
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": {
                this.out.append(" % ");
                break;
            }
            case "CONCAT": {
                this.out.append(" + ");
                break;
            }
            default: {
                super.appendFunctionArgDivider(functionExpression);
            }
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        switch (functionExpression.getFunctionName()) {
            case "MOD": 
            case "CONCAT": {
                this.out.delete(this.out.length() - 3, this.out.length());
                break;
            }
            default: {
                super.clearLastFunctionArgDivider(functionExpression);
            }
        }
    }
}

