/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.io.IOException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.PatternMatchNode;

public class PostgresQualifierTranslator
extends TrimmingQualifierTranslator {
    public PostgresQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler, "RTRIM");
    }

    @Override
    public void startNode(Expression node, Expression parentNode) {
        boolean likeIgnoreCase;
        boolean bl = likeIgnoreCase = node.getType() == 12 || node.getType() == 38;
        if (likeIgnoreCase) {
            this.detectObjectMatch(node);
            if (this.parenthesisNeeded(node, parentNode)) {
                this.out.append('(');
            }
        } else {
            super.startNode(node, parentNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endNode(Expression node, Expression parentNode) {
        boolean likeIgnoreCase;
        boolean bl = likeIgnoreCase = node.getType() == 12 || node.getType() == 38;
        if (likeIgnoreCase) {
            try {
                if (this.matchingObject) {
                    this.appendObjectMatch();
                }
                if (PatternMatchNode.class.isAssignableFrom(node.getClass())) {
                    this.appendLikeEscapeCharacter((PatternMatchNode)node);
                }
                if (!this.parenthesisNeeded(node, parentNode)) return;
                this.out.append(')');
                return;
            }
            catch (IOException ioex) {
                throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
            }
        } else {
            super.endNode(node, parentNode);
        }
    }

    @Override
    public void finishedChild(Expression node, int childIndex, boolean hasMoreChildren) {
        if (!hasMoreChildren) {
            return;
        }
        try {
            switch (node.getType()) {
                case 12: {
                    this.finishedChildNodeAppendExpression(node, " ILIKE ");
                    break;
                }
                case 38: {
                    this.finishedChildNodeAppendExpression(node, " NOT ILIKE ");
                    break;
                }
                default: {
                    super.finishedChild(node, childIndex, hasMoreChildren);
                    break;
                }
            }
        }
        catch (IOException ioex) {
            throw new CayenneRuntimeException("Error appending content", (Throwable)ioex, new Object[0]);
        }
    }

    private void finishedChildNodeAppendExpression(Expression node, String operation) throws IOException {
        StringBuilder buf = this.matchingObject ? new StringBuilder() : this.out;
        buf.append((CharSequence)operation);
        if (this.matchingObject) {
            this.objectMatchTranslator.setOperation(((Object)buf).toString());
            this.objectMatchTranslator.setExpression(node);
        }
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        if ("LOCATE".equals(functionExpression.getFunctionName())) {
            this.out.append("POSITION");
        } else {
            super.appendFunction(functionExpression);
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("LOCATE".equals(functionExpression.getFunctionName())) {
            this.out.append(" in ");
        } else {
            super.appendFunctionArgDivider(functionExpression);
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("LOCATE".equals(functionExpression.getFunctionName())) {
            this.out.delete(this.out.length() - " in ".length(), this.out.length());
        } else {
            super.clearLastFunctionArgDivider(functionExpression);
        }
    }
}

