/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.util.ArrayList;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.ASTIn;
import org.apache.cayenne.exp.parser.ASTList;
import org.apache.cayenne.exp.parser.ASTNegate;
import org.apache.cayenne.exp.parser.ASTNotIn;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.Node;
import org.apache.commons.collections.Transformer;

public class OracleQualifierTranslator
extends TrimmingQualifierTranslator {
    public OracleQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler, "RTRIM");
    }

    @Override
    protected void doAppendPart(Expression rootNode) {
        if (rootNode == null) {
            return;
        }
        rootNode = rootNode.transform(new INTrimmer());
        rootNode.traverse(this);
    }

    @Override
    public void endNode(Expression node, Expression parentNode) {
        super.endNode(node, parentNode);
        if (node.getType() == 45 && "LOCATE".equals(((ASTFunctionCall)node).getFunctionName())) {
            this.swapNodeChildren((ASTFunctionCall)node, 0, 1);
        }
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        if (!"CONCAT".equals(functionExpression.getFunctionName())) {
            if ("SUBSTRING".equals(functionExpression.getFunctionName())) {
                this.out.append("SUBSTR");
            } else if ("LOCATE".equals(functionExpression.getFunctionName())) {
                this.out.append("INSTR");
                this.swapNodeChildren(functionExpression, 0, 1);
            } else if ("CURRENT_TIME".equals(functionExpression.getFunctionName())) {
                this.out.append("{fn CURTIME()}");
            } else {
                super.appendFunction(functionExpression);
            }
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.append(" || ");
        } else {
            super.appendFunctionArgDivider(functionExpression);
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.delete(this.out.length() - " || ".length(), this.out.length());
        } else {
            super.clearLastFunctionArgDivider(functionExpression);
        }
    }

    private void swapNodeChildren(Node node, int i, int j) {
        Node ni = node.jjtGetChild(i);
        Node nj = node.jjtGetChild(j);
        node.jjtAddChild(ni, j);
        node.jjtAddChild(nj, i);
    }

    public static class INTrimmer
    implements Transformer {
        public Expression trimmedInExpression(Expression exp, int maxInSize) {
            Expression list = (Expression)exp.getOperand(1);
            Object[] objects = (Object[])list.evaluate(null);
            if (objects.length <= maxInSize) {
                return exp;
            }
            Expression trimmed = this.trimmedInExpression((ASTPath)exp.getOperand(0), objects, maxInSize);
            if (exp instanceof ASTNotIn) {
                return new ASTNegate(trimmed);
            }
            return trimmed;
        }

        Expression trimmedInExpression(ASTPath path, Object[] values, int maxInSize) {
            ASTIn res = null;
            ArrayList<Object> in = new ArrayList<Object>(maxInSize);
            for (Object v : values) {
                in.add(v);
                if (in.size() != maxInSize) continue;
                ASTIn inExp = new ASTIn(path, new ASTList(in));
                res = res != null ? res.orExp(inExp) : inExp;
                in = new ArrayList(maxInSize);
            }
            if (in.size() > 0) {
                ASTIn inExp = new ASTIn(path, new ASTList(in));
                res = res != null ? res.orExp(inExp) : inExp;
            }
            return res;
        }

        public Object transform(Object input) {
            if (input instanceof ASTIn || input instanceof ASTNotIn) {
                return this.trimmedInExpression((Expression)input, 1000);
            }
            return input;
        }
    }
}

