/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.access.translator.batch.DefaultBatchTranslator;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;

abstract class Oracle8LOBBatchTranslator
extends DefaultBatchTranslator {
    protected String newClobFunction;
    protected String newBlobFunction;

    Oracle8LOBBatchTranslator(BatchQuery query, DbAdapter adapter, String trimFunction) {
        super(query, adapter, trimFunction);
    }

    abstract List<Object> getValuesForLOBUpdateParameters(BatchQueryRow var1);

    abstract String createSql(BatchQueryRow var1);

    @Override
    protected String createSql() {
        throw new UnsupportedOperationException();
    }

    String createLOBSelectString(List<DbAttribute> selectedLOBAttributes, List<DbAttribute> qualifierAttributes) {
        QuotingStrategy strategy = this.adapter.getQuotingStrategy();
        StringBuilder buf = new StringBuilder();
        buf.append("SELECT ");
        Iterator<DbAttribute> it = selectedLOBAttributes.iterator();
        while (it.hasNext()) {
            buf.append(strategy.quotedName(it.next()));
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(" FROM ").append(strategy.quotedFullyQualifiedName(this.query.getDbEntity())).append(" WHERE ");
        it = qualifierAttributes.iterator();
        while (it.hasNext()) {
            DbAttribute attribute = it.next();
            this.appendDbAttribute(buf, attribute);
            buf.append(" = ?");
            if (!it.hasNext()) continue;
            buf.append(" AND ");
        }
        buf.append(" FOR UPDATE");
        return buf.toString();
    }

    protected void appendUpdatedParameter(StringBuilder buf, DbAttribute dbAttribute, Object value) {
        int type = dbAttribute.getType();
        if (this.isUpdateableColumn(value, type)) {
            buf.append('?');
        } else if (type == 2005) {
            buf.append(this.newClobFunction);
        } else if (type == 2004) {
            buf.append(this.newBlobFunction);
        } else {
            throw new CayenneRuntimeException("Unknown LOB column type: " + type + "(" + TypesMapping.getSqlNameByType(type) + "). Query buffer: " + buf, new Object[0]);
        }
    }

    @Override
    protected DbAttributeBinding[] createBindings() {
        List<DbAttribute> dbAttributes = this.query.getDbAttributes();
        int len = dbAttributes.size();
        DbAttributeBinding[] bindings = new DbAttributeBinding[len];
        for (int i = 0; i < len; ++i) {
            bindings[i] = new DbAttributeBinding(dbAttributes.get(i));
        }
        return bindings;
    }

    @Override
    protected DbAttributeBinding[] doUpdateBindings(BatchQueryRow row) {
        int len = this.bindings.length;
        int j = 1;
        for (int i = 0; i < len; ++i) {
            DbAttribute attribute;
            int type;
            DbAttributeBinding b = this.bindings[i];
            Object value = row.getValue(i);
            if (this.isUpdateableColumn(value, type = (attribute = b.getAttribute()).getType())) {
                ExtendedType extendedType = value != null ? this.adapter.getExtendedTypes().getRegisteredType(value.getClass()) : this.adapter.getExtendedTypes().getDefaultType();
                b.include(j++, value, extendedType);
                continue;
            }
            b.exclude();
        }
        return this.bindings;
    }

    protected boolean isUpdateableColumn(Object value, int type) {
        return value == null || type != 2004 && type != 2005;
    }

    void setNewBlobFunction(String string) {
        this.newBlobFunction = string;
    }

    void setNewClobFunction(String string) {
        this.newClobFunction = string;
    }
}

