/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.ingres;

import java.io.IOException;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.TrimmingQualifierTranslator;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTFunctionCall;
import org.apache.cayenne.exp.parser.Node;

class IngresQualifierTranslator
extends TrimmingQualifierTranslator {
    IngresQualifierTranslator(QueryAssembler queryAssembler) {
        super(queryAssembler, "TRIM");
    }

    @Override
    public void endNode(Expression node, Expression parentNode) {
        super.endNode(node, parentNode);
        if (node.getType() == 45 && "LOCATE".equals(((ASTFunctionCall)node).getFunctionName())) {
            this.swapNodeChildren((ASTFunctionCall)node, 0, 1);
        }
    }

    @Override
    protected void appendFunction(ASTFunctionCall functionExpression) {
        if (!"CONCAT".equals(functionExpression.getFunctionName())) {
            if ("LOCATE".equals(functionExpression.getFunctionName())) {
                this.out.append("LOCATE");
                this.swapNodeChildren(functionExpression, 0, 1);
            } else if ("TRIM".equals(functionExpression.getFunctionName())) {
                this.out.append("LTRIM(RTRIM");
            } else {
                super.appendFunction(functionExpression);
            }
        }
    }

    @Override
    protected void appendFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.append(" + ");
        } else {
            super.appendFunctionArgDivider(functionExpression);
        }
    }

    @Override
    protected void appendFunctionArg(Object value, ASTFunctionCall functionExpression) throws IOException {
        if ("SUBSTRING".equals(functionExpression.getFunctionName())) {
            this.out.append("CAST(");
            super.appendFunctionArg(value, functionExpression);
            this.clearLastFunctionArgDivider(functionExpression);
            this.out.append(" AS INTEGER)");
            this.appendFunctionArgDivider(functionExpression);
        } else {
            super.appendFunctionArg(value, functionExpression);
        }
    }

    @Override
    protected void clearLastFunctionArgDivider(ASTFunctionCall functionExpression) {
        if ("CONCAT".equals(functionExpression.getFunctionName())) {
            this.out.delete(this.out.length() - " + ".length(), this.out.length());
        } else {
            super.clearLastFunctionArgDivider(functionExpression);
            if ("TRIM".equals(functionExpression.getFunctionName())) {
                this.out.append(")");
            }
        }
    }

    private void swapNodeChildren(Node node, int i, int j) {
        Node ni = node.jjtGetChild(i);
        Node nj = node.jjtGetChild(j);
        node.jjtAddChild(ni, j);
        node.jjtAddChild(nj, i);
    }
}

