/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.UUID;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.types.ExtendedType;

public class UUIDType
implements ExtendedType<UUID> {
    @Override
    public String getClassName() {
        return UUID.class.getName();
    }

    @Override
    public UUID materializeObject(ResultSet rs, int index, int type) throws Exception {
        String uuid = rs.getString(index);
        if (uuid == null) {
            return null;
        }
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new CayenneRuntimeException("Invalid UUID value: " + uuid, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public UUID materializeObject(CallableStatement rs, int index, int type) throws Exception {
        String uuid = rs.getString(index);
        if (uuid == null) {
            return null;
        }
        try {
            return UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            throw new CayenneRuntimeException("Invalid UUID value: " + uuid, (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, UUID value, int pos, int type, int scale) throws Exception {
        if (value == null) {
            statement.setNull(pos, type);
        } else {
            statement.setObject(pos, (Object)value.toString(), type);
        }
    }

    @Override
    public String toString(UUID value) {
        if (value == null) {
            return "NULL";
        }
        return value.toString();
    }
}

