/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.jdbc.BatchAction;
import org.apache.cayenne.access.jdbc.EJBQLAction;
import org.apache.cayenne.access.jdbc.ProcedureAction;
import org.apache.cayenne.access.jdbc.SQLTemplateAction;
import org.apache.cayenne.access.jdbc.SelectAction;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.query.ProcedureQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.query.SelectQuery;

public class JdbcActionBuilder
implements SQLActionVisitor {
    protected DataNode dataNode;

    public JdbcActionBuilder(DataNode dataNode) {
        this.dataNode = dataNode;
    }

    @Override
    public SQLAction batchAction(BatchQuery query) {
        boolean useOptimisticLock = query.isUsingOptimisticLocking();
        boolean runningAsBatch = !useOptimisticLock && this.dataNode.getAdapter().supportsBatchUpdates();
        return new BatchAction(query, this.dataNode, runningAsBatch);
    }

    @Override
    public SQLAction procedureAction(ProcedureQuery query) {
        return new ProcedureAction(query, this.dataNode);
    }

    @Override
    public <T> SQLAction objectSelectAction(SelectQuery<T> query) {
        return new SelectAction(query, this.dataNode);
    }

    @Override
    public SQLAction sqlAction(SQLTemplate query) {
        return new SQLTemplateAction(query, this.dataNode);
    }

    @Override
    public SQLAction ejbqlAction(EJBQLQuery query) {
        return new EJBQLAction(query, this, this.dataNode);
    }
}

