/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.audit;

import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.DataChannel;
import org.apache.cayenne.DataChannelFilter;
import org.apache.cayenne.DataChannelFilterChain;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.annotation.PostPersist;
import org.apache.cayenne.annotation.PostRemove;
import org.apache.cayenne.annotation.PostUpdate;
import org.apache.cayenne.graph.GraphDiff;
import org.apache.cayenne.lifecycle.audit.Auditable;
import org.apache.cayenne.lifecycle.audit.AuditableAggregator;
import org.apache.cayenne.lifecycle.audit.AuditableChild;
import org.apache.cayenne.lifecycle.audit.AuditableEntityDescriptor;
import org.apache.cayenne.lifecycle.audit.AuditableOperation;
import org.apache.cayenne.lifecycle.audit.AuditableProcessor;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.Query;

public class AuditableFilter
implements DataChannelFilter {
    private ThreadLocal<AuditableAggregator> threadAggregator;
    private ConcurrentMap<String, AuditableEntityDescriptor> entityDescriptors;
    protected AuditableProcessor processor;
    protected EntityResolver entityResolver;

    public AuditableFilter(AuditableProcessor processor) {
        this.processor = processor;
        this.entityDescriptors = new ConcurrentHashMap<String, AuditableEntityDescriptor>();
        this.threadAggregator = new ThreadLocal();
    }

    @Deprecated
    public AuditableFilter(EntityResolver entityResolver, AuditableProcessor processor) {
        this(processor);
    }

    public void init(DataChannel channel) {
        this.entityResolver = channel.getEntityResolver();
    }

    public QueryResponse onQuery(ObjectContext originatingContext, Query query, DataChannelFilterChain filterChain) {
        return filterChain.onQuery(originatingContext, query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphDiff onSync(ObjectContext originatingContext, GraphDiff changes, int syncType, DataChannelFilterChain filterChain) {
        GraphDiff response;
        try {
            response = filterChain.onSync(originatingContext, changes, syncType);
            if (syncType == 2 || syncType == 1) {
                this.postSync();
            }
        }
        finally {
            this.cleanupPostSync();
        }
        return response;
    }

    protected void cleanupPostSync() {
        this.threadAggregator.set(null);
    }

    void postSync() {
        AuditableAggregator aggregator = this.threadAggregator.get();
        if (aggregator != null) {
            this.threadAggregator.set(null);
            aggregator.postSync();
        }
    }

    private AuditableAggregator getAggregator() {
        AuditableAggregator aggregator = this.threadAggregator.get();
        if (aggregator == null) {
            aggregator = new AuditableAggregator(this.processor);
            this.threadAggregator.set(aggregator);
        }
        return aggregator;
    }

    @PostPersist(entityAnnotations={Auditable.class})
    void insertAudit(Persistent object) {
        this.getAggregator().audit(object, AuditableOperation.INSERT);
    }

    @PostRemove(entityAnnotations={Auditable.class})
    void deleteAudit(Persistent object) {
        this.getAggregator().audit(object, AuditableOperation.DELETE);
    }

    @PostUpdate(entityAnnotations={Auditable.class})
    void updateAudit(Persistent object) {
        if (this.isAuditableUpdate(object, false)) {
            this.getAggregator().audit(object, AuditableOperation.UPDATE);
        }
    }

    @PostUpdate(entityAnnotations={AuditableChild.class})
    void updateAuditChild(Persistent object) {
        Persistent parent;
        if (this.isAuditableUpdate(object, true) && (parent = this.getParent(object)) != null) {
            this.getAggregator().audit(parent, AuditableOperation.UPDATE);
        }
    }

    protected Persistent getParent(Persistent object) {
        if (object == null) {
            throw new NullPointerException("Null object");
        }
        if (!(object instanceof DataObject)) {
            throw new IllegalArgumentException("Object is not a DataObject: " + object.getClass().getName());
        }
        DataObject dataObject = (DataObject)object;
        AuditableChild annotation = dataObject.getClass().getAnnotation(AuditableChild.class);
        if (annotation == null) {
            throw new IllegalArgumentException("No 'AuditableChild' annotation found");
        }
        String propertyPath = annotation.value();
        if (propertyPath == null || propertyPath.equals("")) {
            propertyPath = this.objectIdRelationshipName(annotation.objectIdRelationship());
        }
        if (propertyPath == null || propertyPath.equals("")) {
            throw new IllegalStateException("Either 'value' or 'objectIdRelationship' of @AuditableChild must be set");
        }
        return (Persistent)dataObject.readNestedProperty(propertyPath);
    }

    private String objectIdRelationshipName(String uuidPropertyName) {
        return "cay:related:" + uuidPropertyName;
    }

    protected boolean isAuditableUpdate(Object object, boolean child) {
        AuditableEntityDescriptor descriptor = this.getEntityDescriptor(object, child);
        return descriptor.auditableChange((Persistent)object);
    }

    private AuditableEntityDescriptor getEntityDescriptor(Object object, boolean child) {
        ObjEntity entity = this.entityResolver.lookupObjEntity(object);
        AuditableEntityDescriptor descriptor = (AuditableEntityDescriptor)this.entityDescriptors.get(entity.getName());
        if (descriptor == null) {
            Annotation annotation;
            String[] ignoredProperties = child ? ((annotation = object.getClass().getAnnotation(AuditableChild.class)) != null ? annotation.ignoredProperties() : null) : ((annotation = object.getClass().getAnnotation(Auditable.class)) != null ? annotation.ignoredProperties() : null);
            descriptor = new AuditableEntityDescriptor(entity, ignoredProperties);
            AuditableEntityDescriptor existingDescriptor = this.entityDescriptors.putIfAbsent(entity.getName(), descriptor);
            if (existingDescriptor != null) {
                descriptor = existingDescriptor;
            }
        }
        return descriptor;
    }
}

