/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.relationship;

import org.apache.cayenne.DataObject;
import org.apache.cayenne.lifecycle.ref.ReferenceableHandler;
import org.apache.cayenne.lifecycle.relationship.UuidRelationship;
import org.apache.cayenne.lifecycle.relationship.update.UuidPropagatedValueFactory;

public class UuidRelationshipHandler {
    protected ReferenceableHandler referenceableHandler;

    public UuidRelationshipHandler(ReferenceableHandler referenceableHandler) {
        this.referenceableHandler = referenceableHandler;
    }

    public String uuidRelationshipName(String uuidPropertyName) {
        return "cay:related:" + uuidPropertyName;
    }

    public String uuidPropertyName(DataObject object) {
        UuidRelationship annotation = object.getClass().getAnnotation(UuidRelationship.class);
        if (annotation == null) {
            throw new IllegalArgumentException("Object class is not annotated with @UuidRelationship: " + object.getClass().getName());
        }
        return annotation.value();
    }

    public void relate(DataObject from, DataObject to) {
        if (from.getObjectContext() == null) {
            throw new IllegalArgumentException("'from' has null ObjectContext");
        }
        String property = this.uuidPropertyName(from);
        String relationship = this.uuidRelationshipName(property);
        if (to != null) {
            if (to.getObjectContext() == null) {
                throw new IllegalArgumentException("'to' has null ObjectContext");
            }
            if (from.getObjectContext() != to.getObjectContext()) {
                throw new IllegalArgumentException("'from' and 'to' objects are registered in different ObjectContexts");
            }
            from.writePropertyDirectly(relationship, (Object)to);
            if (to.getObjectId().isTemporary() && !to.getObjectId().isReplacementIdAttached()) {
                from.writeProperty(property, (Object)new UuidPropagatedValueFactory(this.referenceableHandler, to));
            } else {
                String uuid = this.referenceableHandler.getUuid(to);
                from.writeProperty(property, (Object)uuid);
            }
        } else {
            from.writeProperty(property, null);
            from.writePropertyDirectly(relationship, null);
        }
    }
}

