/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.lifecycle.ref;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.lifecycle.uuid.UuidCoder;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;

public class ReferenceableHandler {
    protected EntityResolver entityResolver;
    protected Map<String, UuidCoder> coders;

    public ReferenceableHandler(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
        this.coders = new ConcurrentHashMap<String, UuidCoder>();
    }

    public Object getReferenceable(ObjectContext context, String uuid) {
        String entityName = UuidCoder.getEntityName(uuid);
        UuidCoder coder = this.getCoder(entityName);
        ObjectId oid = coder.toObjectId(uuid);
        return Cayenne.objectForPK((ObjectContext)context, (ObjectId)oid);
    }

    public String getUuid(Object referenceable) {
        if (referenceable == null) {
            throw new NullPointerException("Null object");
        }
        if (referenceable instanceof Persistent) {
            ObjectId id = ((Persistent)referenceable).getObjectId();
            UuidCoder coder = this.getCoder(id.getEntityName());
            return coder.toUuid(id);
        }
        throw new IllegalArgumentException("Object is not a DataObject: " + referenceable.getClass().getName());
    }

    protected UuidCoder getCoder(String entityName) {
        UuidCoder coder = this.coders.get(entityName);
        if (coder == null) {
            ObjEntity entity = this.entityResolver.getObjEntity(entityName);
            if (entity == null) {
                throw new IllegalArgumentException("Entity '" + entityName + "' is not a known referenceable");
            }
            coder = new UuidCoder(entity);
            this.coders.put(entity.getName(), coder);
        }
        return coder;
    }
}

