/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.nio.charset.Charset;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;

final class Utf8StringConverter
implements BytesConverter {
    static final String DEFAULT_CHARSET = "UTF-8";
    static final BytesConverter INSTANCE = new Utf8StringConverter();
    private Charset utf8 = Charset.forName("UTF-8");

    Utf8StringConverter() {
    }

    @Override
    public byte[] toBytes(Object value) {
        return ((String)value).getBytes(this.utf8);
    }

    @Override
    public Object fromBytes(byte[] bytes) {
        return new String(bytes, this.utf8);
    }
}

