/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.security.Key;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.transformer.value.Base64StringConverter;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.BytesToBytesConverter;
import org.apache.cayenne.crypto.transformer.value.DefaultValueDecryptor;
import org.apache.cayenne.crypto.transformer.value.DefaultValueEncryptor;
import org.apache.cayenne.crypto.transformer.value.Utf8StringConverter;
import org.apache.cayenne.crypto.transformer.value.ValueDecryptor;
import org.apache.cayenne.crypto.transformer.value.ValueEncryptor;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;

public class DefaultValueTransformerFactory
implements ValueTransformerFactory {
    private final Key defaultKey;
    private final Map<String, BytesConverter> objectToBytes;
    private final Map<Integer, BytesConverter> dbToBytes;
    private final Map<String, BytesConverter> bytesToObject;
    private final Map<Integer, BytesConverter> bytesToDb;
    private final ConcurrentMap<DbAttribute, ValueEncryptor> encryptors;
    private final ConcurrentMap<DbAttribute, ValueDecryptor> decryptors;

    public DefaultValueTransformerFactory(@Inject KeySource keySource) {
        this.defaultKey = keySource.getKey(keySource.getDefaultKeyAlias());
        this.encryptors = new ConcurrentHashMap<DbAttribute, ValueEncryptor>();
        this.decryptors = new ConcurrentHashMap<DbAttribute, ValueDecryptor>();
        this.objectToBytes = this.createObjectToBytesConverters();
        this.dbToBytes = this.createDbToBytesConverters();
        this.bytesToObject = this.createBytesToObjectConverters();
        this.bytesToDb = this.createBytesToDbConverters();
    }

    @Override
    public ValueDecryptor decryptor(DbAttribute a) {
        ValueDecryptor e = (ValueDecryptor)this.decryptors.get(a);
        if (e == null) {
            ValueDecryptor newTransformer = this.createDecryptor(a);
            ValueDecryptor oldTransformer = this.decryptors.putIfAbsent(a, newTransformer);
            e = oldTransformer != null ? oldTransformer : newTransformer;
        }
        return e;
    }

    @Override
    public ValueEncryptor encryptor(DbAttribute a) {
        ValueEncryptor e = (ValueEncryptor)this.encryptors.get(a);
        if (e == null) {
            ValueEncryptor newTransformer = this.createEncryptor(a);
            ValueEncryptor oldTransformer = this.encryptors.putIfAbsent(a, newTransformer);
            e = oldTransformer != null ? oldTransformer : newTransformer;
        }
        return e;
    }

    protected Map<Integer, BytesConverter> createDbToBytesConverters() {
        HashMap<Integer, BytesConverter> map = new HashMap<Integer, BytesConverter>();
        map.put(-2, BytesToBytesConverter.INSTANCE);
        map.put(2004, BytesToBytesConverter.INSTANCE);
        map.put(-3, BytesToBytesConverter.INSTANCE);
        map.put(-4, BytesToBytesConverter.INSTANCE);
        map.put(1, Base64StringConverter.INSTANCE);
        map.put(-15, Base64StringConverter.INSTANCE);
        map.put(2005, Base64StringConverter.INSTANCE);
        map.put(2011, Base64StringConverter.INSTANCE);
        map.put(-1, Base64StringConverter.INSTANCE);
        map.put(-16, Base64StringConverter.INSTANCE);
        map.put(12, Base64StringConverter.INSTANCE);
        map.put(-9, Base64StringConverter.INSTANCE);
        return map;
    }

    protected Map<Integer, BytesConverter> createBytesToDbConverters() {
        HashMap<Integer, BytesConverter> map = new HashMap<Integer, BytesConverter>();
        map.put(-2, BytesToBytesConverter.INSTANCE);
        map.put(2004, BytesToBytesConverter.INSTANCE);
        map.put(-3, BytesToBytesConverter.INSTANCE);
        map.put(-4, BytesToBytesConverter.INSTANCE);
        map.put(1, Base64StringConverter.INSTANCE);
        map.put(-15, Base64StringConverter.INSTANCE);
        map.put(2005, Base64StringConverter.INSTANCE);
        map.put(2011, Base64StringConverter.INSTANCE);
        map.put(-1, Base64StringConverter.INSTANCE);
        map.put(-16, Base64StringConverter.INSTANCE);
        map.put(12, Base64StringConverter.INSTANCE);
        map.put(-9, Base64StringConverter.INSTANCE);
        return map;
    }

    protected Map<String, BytesConverter> createObjectToBytesConverters() {
        HashMap<String, BytesConverter> map = new HashMap<String, BytesConverter>();
        map.put("byte[]", BytesToBytesConverter.INSTANCE);
        map.put(String.class.getName(), Utf8StringConverter.INSTANCE);
        return map;
    }

    protected Map<String, BytesConverter> createBytesToObjectConverters() {
        HashMap<String, BytesConverter> map = new HashMap<String, BytesConverter>();
        map.put("byte[]", BytesToBytesConverter.INSTANCE);
        map.put(String.class.getName(), Utf8StringConverter.INSTANCE);
        return map;
    }

    protected ValueEncryptor createEncryptor(DbAttribute a) {
        String type = this.getJavaType(a);
        BytesConverter toBytes = this.objectToBytes.get(type);
        if (toBytes == null) {
            throw new IllegalArgumentException("The type " + type + " for attribute " + a + " has no object-to-bytes conversion");
        }
        BytesConverter fromBytes = this.bytesToDb.get(a.getType());
        if (fromBytes == null) {
            throw new IllegalArgumentException("The type " + TypesMapping.getSqlNameByType((int)a.getType()) + " for attribute " + a + " has no bytes-to-db conversion");
        }
        return new DefaultValueEncryptor(toBytes, fromBytes);
    }

    protected ValueDecryptor createDecryptor(DbAttribute a) {
        BytesConverter toBytes = this.dbToBytes.get(a.getType());
        if (toBytes == null) {
            throw new IllegalArgumentException("The type " + TypesMapping.getSqlNameByType((int)a.getType()) + " for attribute " + a + " has no db-to-bytes conversion");
        }
        String type = this.getJavaType(a);
        BytesConverter fromBytes = this.bytesToObject.get(type);
        if (fromBytes == null) {
            throw new IllegalArgumentException("The type " + type + " for attribute " + a + " has no bytes-to-object conversion");
        }
        return new DefaultValueDecryptor(toBytes, fromBytes, this.defaultKey);
    }

    protected String getJavaType(DbAttribute a) {
        DbEntity dbEntity = a.getEntity();
        DataMap dataMap = dbEntity.getDataMap();
        Collection objEntities = dataMap.getMappedEntities(dbEntity);
        if (objEntities.size() != 1) {
            return TypesMapping.getJavaBySqlType((int)a.getType());
        }
        HashSet<String> javaTypes = new HashSet<String>();
        ObjEntity objEntity = (ObjEntity)objEntities.iterator().next();
        for (ObjAttribute oa : objEntity.getAttributes()) {
            if (!a.getName().equals(oa.getDbAttributePath())) continue;
            javaTypes.add(oa.getType());
        }
        if (javaTypes.size() != 1) {
            return TypesMapping.getJavaBySqlType((int)a.getType());
        }
        return (String)javaTypes.iterator().next();
    }
}

