/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.value;

import java.security.Key;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;
import org.apache.cayenne.crypto.transformer.value.BytesConverter;
import org.apache.cayenne.crypto.transformer.value.ValueDecryptor;

class DefaultValueDecryptor
implements ValueDecryptor {
    private Key defaultKey;
    private BytesConverter preConverter;
    private BytesConverter postConverter;

    public DefaultValueDecryptor(BytesConverter preConverter, BytesConverter postConverter, Key defaultKey) {
        this.preConverter = preConverter;
        this.postConverter = postConverter;
    }

    BytesConverter getPreConverter() {
        return this.preConverter;
    }

    BytesConverter getPostConverter() {
        return this.postConverter;
    }

    @Override
    public Object decrypt(BytesDecryptor bytesDecryptor, Object value) {
        byte[] bytes = this.preConverter.toBytes(value);
        byte[] transformed = bytesDecryptor.decrypt(bytes, 0, this.defaultKey);
        return this.postConverter.fromBytes(transformed);
    }
}

