/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.security.Key;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.Header;

class HeaderDecryptor
implements BytesDecryptor {
    private KeySource keySource;
    private BytesDecryptor delegate;
    private BytesDecryptor decompressDelegate;

    HeaderDecryptor(BytesDecryptor delegate, BytesDecryptor decompressDelegate, KeySource keySource) {
        this.delegate = delegate;
        this.keySource = keySource;
        this.decompressDelegate = decompressDelegate;
    }

    @Override
    public byte[] decrypt(byte[] input, int inputOffset, Key key) {
        Header header = Header.create(input, inputOffset);
        Key inRecordKey = this.keySource.getKey(header.getKeyName());
        BytesDecryptor worker = header.isCompressed() ? this.decompressDelegate : this.delegate;
        return worker.decrypt(input, inputOffset + header.size(), inRecordKey);
    }
}

