/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.io.UnsupportedEncodingException;
import org.apache.cayenne.crypto.CayenneCryptoException;

public class Header {
    private static final String KEY_NAME_CHARSET = "UTF-8";
    private static final byte[] MAGIC_NUMBER = new byte[]{67, 67, 49};
    private static final int MAGIC_NUMBER_POSITION = 0;
    private static final int SIZE_POSITION = 3;
    private static final int FLAGS_POSITION = 4;
    private static final int KEY_NAME_OFFSET = 5;
    private static final int KEY_NAME_MAX_SIZE = 122;
    private static final int COMPRESS_BIT = 0;
    private byte[] data;
    private int offset;

    public static Header create(String keyName, boolean compessed) {
        byte[] keyNameBytes;
        try {
            keyNameBytes = keyName.getBytes(KEY_NAME_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new CayenneCryptoException("Can't encode in UTF-8", e, new Object[0]);
        }
        if (keyNameBytes.length > 122) {
            throw new CayenneCryptoException("Key name '" + keyName + "' is too long. Its UTF8-encoded form should not exceed " + 122 + " bytes", new Object[0]);
        }
        int n = MAGIC_NUMBER.length + 1 + 1 + keyNameBytes.length;
        byte[] data = new byte[n];
        System.arraycopy(MAGIC_NUMBER, 0, data, 0, MAGIC_NUMBER.length);
        data[3] = (byte)n;
        if (compessed) {
            data[4] = Header.bitOn(data[4], 0);
        }
        System.arraycopy(keyNameBytes, 0, data, 5, keyNameBytes.length);
        return Header.create(data, 0);
    }

    public static Header create(byte[] data, int offset) {
        return new Header(data, offset);
    }

    public static byte setCompressed(byte bits, boolean compressed) {
        return compressed ? Header.bitOn(bits, 0) : Header.bitOff(bits, 0);
    }

    private static byte bitOn(byte bits, int position) {
        return (byte)(bits | 1 << position);
    }

    private static byte bitOff(byte bits, int position) {
        return (byte)(bits & ~(1 << position));
    }

    private static boolean isBitOn(byte bits, int position) {
        return (bits >> position & 1) == 1;
    }

    private Header(byte[] data, int offset) {
        this.data = data;
        this.offset = offset;
    }

    public int size() {
        return this.data[this.offset + 3];
    }

    public boolean isCompressed() {
        return Header.isBitOn(this.getFlags(), 0);
    }

    public byte getFlags() {
        return this.data[this.offset + 4];
    }

    public void store(byte[] output, int outputOffset, byte flags) {
        System.arraycopy(this.data, this.offset, output, outputOffset, this.size());
        output[outputOffset + 4] = flags;
    }

    public String getKeyName() {
        try {
            return new String(this.data, this.offset + 5, this.size() - 5, KEY_NAME_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new CayenneCryptoException("Can't decode with UTF-8", e, new Object[0]);
        }
    }
}

