/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer;

import java.util.ArrayList;
import java.util.Map;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.translator.batch.BatchParameterBinding;
import org.apache.cayenne.crypto.map.ColumnMapper;
import org.apache.cayenne.crypto.transformer.BindingsTransformer;
import org.apache.cayenne.crypto.transformer.DefaultBindingsTransformer;
import org.apache.cayenne.crypto.transformer.DefaultMapTransformer;
import org.apache.cayenne.crypto.transformer.MapTransformer;
import org.apache.cayenne.crypto.transformer.TransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.value.ValueDecryptor;
import org.apache.cayenne.crypto.transformer.value.ValueEncryptor;
import org.apache.cayenne.crypto.transformer.value.ValueTransformerFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;

public class DefaultTransformerFactory
implements TransformerFactory {
    private BytesTransformerFactory bytesTransformerFactory;
    private ColumnMapper columnMapper;
    private ValueTransformerFactory transformerFactory;

    public DefaultTransformerFactory(@Inject ColumnMapper columnMapper, @Inject ValueTransformerFactory transformerFactory, @Inject BytesTransformerFactory bytesTransformerFactory) {
        this.columnMapper = columnMapper;
        this.transformerFactory = transformerFactory;
        this.bytesTransformerFactory = bytesTransformerFactory;
    }

    @Override
    public MapTransformer decryptor(ColumnDescriptor[] columns, Object sampleRow) {
        if (!(sampleRow instanceof Map)) {
            return null;
        }
        int len = columns.length;
        ArrayList<Integer> cryptoColumns = null;
        for (int i = 0; i < len; ++i) {
            DbAttribute a = columns[i].getAttribute();
            if (a == null || !this.columnMapper.isEncrypted(a)) continue;
            if (cryptoColumns == null) {
                cryptoColumns = new ArrayList<Integer>(len - i);
            }
            cryptoColumns.add(i);
        }
        if (cryptoColumns != null) {
            int dlen = cryptoColumns.size();
            String[] mapKeys = new String[dlen];
            ValueDecryptor[] transformers = new ValueDecryptor[dlen];
            for (int i = 0; i < dlen; ++i) {
                ColumnDescriptor cd = columns[(Integer)cryptoColumns.get(i)];
                mapKeys[i] = cd.getDataRowKey();
                transformers[i] = this.transformerFactory.decryptor(cd.getAttribute());
            }
            return new DefaultMapTransformer(mapKeys, transformers, this.bytesTransformerFactory.decryptor());
        }
        return null;
    }

    @Override
    public BindingsTransformer encryptor(BatchParameterBinding[] bindings) {
        int len = bindings.length;
        ArrayList<Integer> cryptoColumns = null;
        for (int i = 0; i < len; ++i) {
            DbAttribute a = bindings[i].getAttribute();
            if (!this.columnMapper.isEncrypted(a)) continue;
            if (cryptoColumns == null) {
                cryptoColumns = new ArrayList<Integer>(len - i);
            }
            cryptoColumns.add(i);
        }
        if (cryptoColumns != null) {
            int dlen = cryptoColumns.size();
            int[] positions = new int[dlen];
            ValueEncryptor[] transformers = new ValueEncryptor[dlen];
            for (int i = 0; i < dlen; ++i) {
                int pos = (Integer)cryptoColumns.get(i);
                BatchParameterBinding b = bindings[pos];
                positions[i] = pos;
                transformers[i] = this.transformerFactory.encryptor(b.getAttribute());
            }
            return new DefaultBindingsTransformer(positions, transformers, this.bytesTransformerFactory.encryptor());
        }
        return null;
    }
}

