/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer;

import org.apache.cayenne.access.translator.batch.BatchParameterBinding;
import org.apache.cayenne.crypto.transformer.BindingsTransformer;
import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;
import org.apache.cayenne.crypto.transformer.value.ValueEncryptor;

public class DefaultBindingsTransformer
implements BindingsTransformer {
    private int[] positions;
    private ValueEncryptor[] transformers;
    private BytesEncryptor encryptor;

    public DefaultBindingsTransformer(int[] positions, ValueEncryptor[] transformers, BytesEncryptor encryptor) {
        this.positions = positions;
        this.transformers = transformers;
        this.encryptor = encryptor;
    }

    @Override
    public void transform(BatchParameterBinding[] bindings) {
        int len = this.positions.length;
        for (int i = 0; i < len; ++i) {
            BatchParameterBinding b = bindings[this.positions[i]];
            Object transformed = this.transformers[i].encrypt(this.encryptor, b.getValue());
            b.setValue(transformed);
        }
    }
}

