/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.reader;

import java.sql.ResultSet;
import java.util.Map;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.jdbc.reader.RowReader;
import org.apache.cayenne.access.jdbc.reader.RowReaderFactory;
import org.apache.cayenne.crypto.transformer.MapTransformer;
import org.apache.cayenne.crypto.transformer.TransformerFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.query.QueryMetadata;

public class CryptoRowReaderFactoryDecorator
implements RowReaderFactory {
    private RowReaderFactory delegate;
    private TransformerFactory transformerFactory;

    public CryptoRowReaderFactoryDecorator(@Inject RowReaderFactory delegate, @Inject TransformerFactory transformerFactory) {
        this.delegate = delegate;
        this.transformerFactory = transformerFactory;
    }

    public RowReader<?> rowReader(final RowDescriptor descriptor, QueryMetadata queryMetadata, DbAdapter adapter, Map<ObjAttribute, ColumnDescriptor> attributeOverrides) {
        final RowReader delegateReader = this.delegate.rowReader(descriptor, queryMetadata, adapter, attributeOverrides);
        return new RowReader<Object>(){
            private boolean decryptorCompiled;
            private MapTransformer decryptor;

            private void ensureDecryptorCompiled(Object row) {
                if (!this.decryptorCompiled) {
                    this.decryptor = CryptoRowReaderFactoryDecorator.this.transformerFactory.decryptor(descriptor.getColumns(), row);
                    this.decryptorCompiled = true;
                }
            }

            public Object readRow(ResultSet resultSet) {
                Object row = delegateReader.readRow(resultSet);
                this.ensureDecryptorCompiled(row);
                if (this.decryptor != null) {
                    Map map = (Map)row;
                    this.decryptor.transform(map);
                }
                return row;
            }
        };
    }
}

