/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.key;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.crypto.CayenneCryptoException;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.di.Inject;

public class JceksKeySource
implements KeySource {
    private static final String JCEKS_KEYSTORE_TYPE = "jceks";
    private static final Key NULL_KEY = new Key(){
        private static final long serialVersionUID = 4755682444381893880L;

        @Override
        public String getFormat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] getEncoded() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAlgorithm() {
            throw new UnsupportedOperationException();
        }
    };
    private KeyStore keyStore;
    private char[] keyPassword;
    private String defaultKeyAlias;
    private ConcurrentMap<String, Key> keyCache;

    public JceksKeySource(@Inject(value="cayenne.crypto.properties") Map<String, String> properties, @Inject(value="cayenne.crypto.properties") Map<String, char[]> credentials) {
        String keyStoreUrl = properties.get("cayenne.crypto.keystore.url");
        if (keyStoreUrl == null) {
            throw new CayenneCryptoException("KeyStore URL is not set. Property name: cayenne.crypto.keystore.url", new Object[0]);
        }
        this.keyPassword = credentials.get("cayenne.crypto.key.password");
        try {
            this.keyStore = this.createKeyStore(keyStoreUrl);
        }
        catch (Exception e) {
            throw new CayenneCryptoException("Error loading keystore at " + keyStoreUrl, e, new Object[0]);
        }
        this.defaultKeyAlias = properties.get("cayenne.crypto.key.enc.alias");
        if (this.defaultKeyAlias == null) {
            throw new CayenneCryptoException("Default key alias is not set. Property name: cayenne.crypto.key.enc.alias", new Object[0]);
        }
        this.keyCache = new ConcurrentHashMap<String, Key>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createKeyStore(String keyStoreUrl) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(JCEKS_KEYSTORE_TYPE);
        URL url = new URL(keyStoreUrl);
        InputStream in = url.openStream();
        try {
            keyStore.load(in, null);
        }
        finally {
            in.close();
        }
        return keyStore;
    }

    @Override
    public Key getKey(String alias) {
        Key key = (Key)this.keyCache.get(alias);
        if (key == null) {
            Key newKey = this.createKey(alias);
            Key oldKey = this.keyCache.putIfAbsent(alias, newKey);
            key = oldKey != null ? oldKey : newKey;
        }
        return key == NULL_KEY ? null : key;
    }

    protected Key createKey(String alias) {
        try {
            Key key = this.keyStore.getKey(alias, this.keyPassword);
            return key != null ? key : NULL_KEY;
        }
        catch (Exception e) {
            throw new CayenneCryptoException("Error accessing key for alias: " + alias, e, new Object[0]);
        }
    }

    @Override
    public String getDefaultKeyAlias() {
        return this.defaultKeyAlias;
    }
}

