/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.batch;

import org.apache.cayenne.access.translator.batch.BatchParameterBinding;
import org.apache.cayenne.access.translator.batch.BatchTranslator;
import org.apache.cayenne.access.translator.batch.BatchTranslatorFactory;
import org.apache.cayenne.crypto.transformer.BindingsTransformer;
import org.apache.cayenne.crypto.transformer.TransformerFactory;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.BatchQueryRow;

public class CryptoBatchTranslatorFactoryDecorator
implements BatchTranslatorFactory {
    private TransformerFactory cryptoFactory;
    private BatchTranslatorFactory delegate;

    public CryptoBatchTranslatorFactoryDecorator(@Inject BatchTranslatorFactory delegate, @Inject TransformerFactory cryptoFactory) {
        this.cryptoFactory = cryptoFactory;
        this.delegate = delegate;
    }

    public BatchTranslator translator(BatchQuery query, DbAdapter adapter, String trimFunction) {
        final BatchTranslator delegateTranslator = this.delegate.translator(query, adapter, trimFunction);
        return new BatchTranslator(){
            private boolean encryptorCompiled;
            private BindingsTransformer encryptor;

            private void ensureEncryptorCompiled() {
                if (!this.encryptorCompiled) {
                    this.encryptor = CryptoBatchTranslatorFactoryDecorator.this.cryptoFactory.encryptor(this.getBindings());
                    this.encryptorCompiled = true;
                }
            }

            public String getSql() {
                return delegateTranslator.getSql();
            }

            public BatchParameterBinding[] getBindings() {
                return delegateTranslator.getBindings();
            }

            public BatchParameterBinding[] updateBindings(BatchQueryRow row) {
                this.ensureEncryptorCompiled();
                BatchParameterBinding[] bindings = delegateTranslator.updateBindings(row);
                if (this.encryptor != null) {
                    this.encryptor.transform(bindings);
                }
                return bindings;
            }
        };
    }
}

