/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.MmapRebufferer;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.RebuffererFactory;
import org.apache.cassandra.io.util.SegmentedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MmappedSegmentedFile
extends SegmentedFile {
    private static final Logger logger = LoggerFactory.getLogger(MmappedSegmentedFile.class);

    public MmappedSegmentedFile(ChannelProxy channel, long length, MmappedRegions regions) {
        this(channel, new MmapRebufferer(channel, length, regions), length);
    }

    public MmappedSegmentedFile(ChannelProxy channel, RebuffererFactory rebufferer, long length) {
        super(new SegmentedFile.Cleanup(channel, rebufferer), channel, rebufferer, length);
    }

    private MmappedSegmentedFile(MmappedSegmentedFile copy) {
        super(copy);
    }

    @Override
    public MmappedSegmentedFile sharedCopy() {
        return new MmappedSegmentedFile(this);
    }

    static class Builder
    extends SegmentedFile.Builder {
        private MmappedRegions regions;

        Builder() {
        }

        @Override
        public SegmentedFile complete(ChannelProxy channel, int bufferSize, long overrideLength) {
            long length = overrideLength > 0L ? overrideLength : channel.size();
            this.updateRegions(channel, length);
            return new MmappedSegmentedFile(channel, length, this.regions.sharedCopy());
        }

        private void updateRegions(ChannelProxy channel, long length) {
            if (this.regions != null && !this.regions.isValid(channel)) {
                Throwable err = this.regions.close(null);
                if (err != null) {
                    logger.error("Failed to close mapped regions", err);
                }
                this.regions = null;
            }
            if (this.regions == null) {
                this.regions = MmappedRegions.map(channel, length);
            } else {
                this.regions.extend(length);
            }
        }

        @Override
        public void serializeBounds(DataOutput out, Version version) throws IOException {
            if (!version.hasBoundaries()) {
                return;
            }
            super.serializeBounds(out, version);
            out.writeInt(0);
        }

        @Override
        public void deserializeBounds(DataInput in, Version version) throws IOException {
            if (!version.hasBoundaries()) {
                return;
            }
            super.deserializeBounds(in, version);
            in.skipBytes(in.readInt() * TypeSizes.sizeof(0L));
        }

        @Override
        public Throwable close(Throwable accumulate) {
            return super.close(this.regions == null ? accumulate : this.regions.close(accumulate));
        }
    }
}

