/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.io.util.BufferedDataOutputStreamPlus;

public class DataOutputBuffer
extends BufferedDataOutputStreamPlus {
    private static final long DOUBLING_THRESHOLD = Long.getLong("cassandra.DOB_DOUBLING_THRESHOLD_MB", 64L);
    @VisibleForTesting
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public DataOutputBuffer() {
        this(128);
    }

    public DataOutputBuffer(int size) {
        super(ByteBuffer.allocate(size));
    }

    protected DataOutputBuffer(ByteBuffer buffer) {
        super(buffer);
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }

    @VisibleForTesting
    static int saturatedArraySizeCast(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0);
        return (int)Math.min(0x7FFFFFF7L, size);
    }

    @VisibleForTesting
    static int checkedArraySizeCast(long size) {
        Preconditions.checkArgument((size >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((size <= 0x7FFFFFF7L ? 1 : 0) != 0);
        return (int)size;
    }

    @Override
    protected void doFlush(int count) throws IOException {
        this.reallocate(count);
    }

    @VisibleForTesting
    long capacity() {
        return this.buffer.capacity();
    }

    @VisibleForTesting
    long validateReallocation(long newSize) {
        int saturatedSize = DataOutputBuffer.saturatedArraySizeCast(newSize);
        if ((long)saturatedSize <= this.capacity()) {
            throw new RuntimeException();
        }
        return saturatedSize;
    }

    @VisibleForTesting
    long calculateNewSize(long count) {
        long capacity = this.capacity();
        long newSize = capacity + count;
        newSize = capacity > 0x100000L * DOUBLING_THRESHOLD ? Math.max(capacity * 3L / 2L, newSize) : Math.max(capacity * 2L, newSize);
        return this.validateReallocation(newSize);
    }

    protected void reallocate(long count) {
        if (count <= 0L) {
            return;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(DataOutputBuffer.checkedArraySizeCast(this.calculateNewSize(count)));
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }

    @Override
    protected WritableByteChannel newDefaultChannel() {
        return new GrowingChannel();
    }

    @Override
    public void close() {
    }

    public ByteBuffer buffer() {
        ByteBuffer result = this.buffer.duplicate();
        result.flip();
        return result;
    }

    public byte[] getData() {
        assert (this.buffer.arrayOffset() == 0);
        return this.buffer.array();
    }

    public int getLength() {
        return this.buffer.position();
    }

    @Override
    public boolean hasPosition() {
        return true;
    }

    @Override
    public long position() {
        return this.getLength();
    }

    public byte[] toByteArray() {
        ByteBuffer buffer = this.buffer();
        byte[] result = new byte[buffer.remaining()];
        buffer.get(result);
        return result;
    }

    @VisibleForTesting
    final class GrowingChannel
    implements WritableByteChannel {
        GrowingChannel() {
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int count = src.remaining();
            DataOutputBuffer.this.reallocate(count);
            DataOutputBuffer.this.buffer.put(src);
            return count;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() {
        }
    }
}

