/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.metadata;

import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.CompactionMetadata;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.StreamingHistogram;

@Deprecated
public class LegacyMetadataSerializer
extends MetadataSerializer {
    @Override
    public void serialize(Map<MetadataType, MetadataComponent> components, DataOutputPlus out, Version version) throws IOException {
        ValidationMetadata validation = (ValidationMetadata)components.get((Object)MetadataType.VALIDATION);
        StatsMetadata stats = (StatsMetadata)components.get((Object)MetadataType.STATS);
        CompactionMetadata compaction = (CompactionMetadata)components.get((Object)MetadataType.COMPACTION);
        assert (validation != null && stats != null && compaction != null && validation.partitioner != null);
        EstimatedHistogram.serializer.serialize(stats.estimatedPartitionSize, out);
        EstimatedHistogram.serializer.serialize(stats.estimatedColumnCount, out);
        ReplayPosition.serializer.serialize(stats.commitLogUpperBound, out);
        out.writeLong(stats.minTimestamp);
        out.writeLong(stats.maxTimestamp);
        out.writeInt(stats.maxLocalDeletionTime);
        out.writeDouble(validation.bloomFilterFPChance);
        out.writeDouble(stats.compressionRatio);
        out.writeUTF(validation.partitioner);
        out.writeInt(0);
        StreamingHistogram.serializer.serialize(stats.estimatedTombstoneDropTime, out);
        out.writeInt(stats.sstableLevel);
        out.writeInt(stats.minClusteringValues.size());
        for (ByteBuffer value : stats.minClusteringValues) {
            ByteBufferUtil.writeWithShortLength(value, out);
        }
        out.writeInt(stats.maxClusteringValues.size());
        for (ByteBuffer value : stats.maxClusteringValues) {
            ByteBufferUtil.writeWithShortLength(value, out);
        }
        if (version.hasCommitLogLowerBound()) {
            ReplayPosition.serializer.serialize(stats.commitLogLowerBound, out);
        }
    }

    @Override
    public Map<MetadataType, MetadataComponent> deserialize(Descriptor descriptor, EnumSet<MetadataType> types) throws IOException {
        HashMap components = Maps.newHashMap();
        File statsFile = new File(descriptor.filenameFor(Component.STATS));
        if (!statsFile.exists() && types.contains((Object)MetadataType.STATS)) {
            components.put(MetadataType.STATS, MetadataCollector.defaultStatsMetadata());
        } else {
            try (DataInputPlus.DataInputStreamPlus in = new DataInputPlus.DataInputStreamPlus(new BufferedInputStream(new FileInputStream(statsFile)));){
                EstimatedHistogram partitionSizes = EstimatedHistogram.serializer.deserialize(in);
                EstimatedHistogram columnCounts = EstimatedHistogram.serializer.deserialize(in);
                ReplayPosition commitLogLowerBound = ReplayPosition.NONE;
                ReplayPosition commitLogUpperBound = ReplayPosition.serializer.deserialize(in);
                long minTimestamp = in.readLong();
                long maxTimestamp = in.readLong();
                int maxLocalDeletionTime = in.readInt();
                double bloomFilterFPChance = in.readDouble();
                double compressionRatio = in.readDouble();
                String partitioner = in.readUTF();
                int nbAncestors = in.readInt();
                in.skipBytes(nbAncestors * TypeSizes.sizeof(nbAncestors));
                StreamingHistogram tombstoneHistogram = StreamingHistogram.serializer.deserialize(in);
                int sstableLevel = 0;
                if (in.available() > 0) {
                    sstableLevel = in.readInt();
                }
                int colCount = in.readInt();
                ArrayList<ByteBuffer> minColumnNames = new ArrayList<ByteBuffer>(colCount);
                for (int i = 0; i < colCount; ++i) {
                    minColumnNames.add(ByteBufferUtil.readWithShortLength(in));
                }
                colCount = in.readInt();
                ArrayList<ByteBuffer> maxColumnNames = new ArrayList<ByteBuffer>(colCount);
                for (int i = 0; i < colCount; ++i) {
                    maxColumnNames.add(ByteBufferUtil.readWithShortLength(in));
                }
                if (descriptor.version.hasCommitLogLowerBound()) {
                    commitLogLowerBound = ReplayPosition.serializer.deserialize(in);
                }
                if (types.contains((Object)MetadataType.VALIDATION)) {
                    components.put(MetadataType.VALIDATION, new ValidationMetadata(partitioner, bloomFilterFPChance));
                }
                if (types.contains((Object)MetadataType.STATS)) {
                    components.put(MetadataType.STATS, new StatsMetadata(partitionSizes, columnCounts, commitLogLowerBound, commitLogUpperBound, minTimestamp, maxTimestamp, Integer.MAX_VALUE, maxLocalDeletionTime, 0, Integer.MAX_VALUE, compressionRatio, tombstoneHistogram, sstableLevel, minColumnNames, maxColumnNames, true, 0L, -1L, -1L));
                }
                if (types.contains((Object)MetadataType.COMPACTION)) {
                    components.put(MetadataType.COMPACTION, new CompactionMetadata(null));
                }
            }
        }
        return components;
    }
}

