/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.RebufferingInputStream;
import org.apache.cassandra.utils.memory.BufferPool;

public class ChecksummedDataInput
extends RebufferingInputStream {
    private final CRC32 crc = new CRC32();
    private int crcPosition = 0;
    private boolean crcUpdateDisabled = false;
    private long limit;
    private long limitMark;
    protected long bufferOffset;
    protected final ChannelProxy channel;

    ChecksummedDataInput(ChannelProxy channel, BufferType bufferType) {
        super(BufferPool.get(4096, bufferType));
        this.channel = channel;
        this.bufferOffset = 0L;
        this.buffer.limit(0);
        this.resetLimit();
    }

    ChecksummedDataInput(ChannelProxy channel) {
        this(channel, BufferType.OFF_HEAP);
    }

    public static ChecksummedDataInput open(File file) {
        return new ChecksummedDataInput(new ChannelProxy(file));
    }

    public boolean isEOF() {
        return this.getPosition() == this.channel.size();
    }

    public long getSourcePosition() {
        return this.getPosition();
    }

    public void resetCrc() {
        this.crc.reset();
        this.crcPosition = this.buffer.position();
    }

    public void limit(long newLimit) {
        this.limitMark = this.getPosition();
        this.limit = this.limitMark + newLimit;
    }

    protected long getPosition() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    public void resetLimit() {
        this.limit = Long.MAX_VALUE;
        this.limitMark = -1L;
    }

    public void checkLimit(int length) throws IOException {
        if (this.getPosition() + (long)length > this.limit) {
            throw new IOException("Digest mismatch exception");
        }
    }

    public long bytesPastLimit() {
        assert (this.limitMark != -1L);
        return this.getPosition() - this.limitMark;
    }

    public boolean checkCrc() throws IOException {
        try {
            this.updateCrc();
            this.crcUpdateDisabled = true;
            boolean bl = (int)this.crc.getValue() == this.readInt();
            return bl;
        }
        finally {
            this.crcPosition = this.buffer.position();
            this.crcUpdateDisabled = false;
        }
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.checkLimit(b.length);
        super.readFully(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkLimit(len);
        return super.read(b, off, len);
    }

    @Override
    protected void reBuffer() {
        Preconditions.checkState((this.buffer.remaining() == 0 ? 1 : 0) != 0);
        this.updateCrc();
        this.bufferOffset += (long)this.buffer.limit();
        this.readBuffer();
        this.crcPosition = this.buffer.position();
    }

    protected void readBuffer() {
        this.buffer.clear();
        while (this.channel.read(this.buffer, this.bufferOffset) == 0) {
        }
        this.buffer.flip();
    }

    private void updateCrc() {
        if (this.crcPosition == this.buffer.position() || this.crcUpdateDisabled) {
            return;
        }
        assert (this.crcPosition >= 0 && this.crcPosition < this.buffer.position());
        ByteBuffer unprocessed = this.buffer.duplicate();
        unprocessed.position(this.crcPosition).limit(this.buffer.position());
        this.crc.update(unprocessed);
    }

    @Override
    public void close() {
        BufferPool.put(this.buffer);
        this.channel.close();
    }

    protected String getPath() {
        return this.channel.filePath();
    }

    public ChannelProxy getChannel() {
        return this.channel;
    }
}

