/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.streaming.StreamResultFuture;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.OutgoingFileMessage;
import org.apache.cassandra.utils.FBUtilities;

public interface StreamHook {
    public static final StreamHook instance = StreamHook.createHook();

    public OutgoingFileMessage reportOutgoingFile(StreamSession var1, SSTableReader var2, OutgoingFileMessage var3);

    public void reportStreamFuture(StreamSession var1, StreamResultFuture var2);

    public void reportIncomingFile(ColumnFamilyStore var1, SSTableMultiWriter var2, StreamSession var3, int var4);

    public static StreamHook createHook() {
        String className = System.getProperty("cassandra.stream_hook");
        if (className != null) {
            return (StreamHook)FBUtilities.construct(className, StreamHook.class.getSimpleName());
        }
        return new StreamHook(){

            @Override
            public OutgoingFileMessage reportOutgoingFile(StreamSession session, SSTableReader sstable, OutgoingFileMessage message) {
                return message;
            }

            @Override
            public void reportStreamFuture(StreamSession session, StreamResultFuture future) {
            }

            @Override
            public void reportIncomingFile(ColumnFamilyStore cfs, SSTableMultiWriter writer, StreamSession session, int sequenceNumber) {
            }
        };
    }
}

