/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleNewTracker;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;

public class MajorLeveledCompactionWriter
extends CompactionAwareWriter {
    private final long maxSSTableSize;
    private int currentLevel = 1;
    private long averageEstimatedKeysPerSSTable;
    private long partitionsWritten = 0L;
    private long totalWrittenInLevel = 0L;
    private int sstablesWritten = 0;
    private final long keysPerSSTable;
    private Directories.DataDirectory sstableDirectory;
    private final int levelFanoutSize;

    public MajorLeveledCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize) {
        this(cfs, directories, txn, nonExpiredSSTables, maxSSTableSize, false);
    }

    @Deprecated
    public MajorLeveledCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, boolean offline, boolean keepOriginals) {
        this(cfs, directories, txn, nonExpiredSSTables, maxSSTableSize, keepOriginals);
    }

    public MajorLeveledCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, long maxSSTableSize, boolean keepOriginals) {
        super(cfs, directories, txn, nonExpiredSSTables, keepOriginals);
        this.maxSSTableSize = maxSSTableSize;
        this.levelFanoutSize = cfs.getLevelFanoutSize();
        long estimatedSSTables = Math.max(1L, SSTableReader.getTotalBytes(nonExpiredSSTables) / maxSSTableSize);
        this.keysPerSSTable = this.estimatedTotalKeys / estimatedSSTables;
    }

    @Override
    public boolean realAppend(UnfilteredRowIterator partition) {
        RowIndexEntry rie = this.sstableWriter.append(partition);
        ++this.partitionsWritten;
        long totalWrittenInCurrentWriter = this.sstableWriter.currentWriter().getEstimatedOnDiskBytesWritten();
        if (totalWrittenInCurrentWriter > this.maxSSTableSize) {
            this.totalWrittenInLevel += totalWrittenInCurrentWriter;
            if (this.totalWrittenInLevel > LeveledManifest.maxBytesForLevel(this.currentLevel, this.levelFanoutSize, this.maxSSTableSize)) {
                this.totalWrittenInLevel = 0L;
                ++this.currentLevel;
            }
            this.switchCompactionLocation(this.sstableDirectory);
        }
        return rie != null;
    }

    @Override
    public void switchCompactionLocation(Directories.DataDirectory location) {
        this.sstableDirectory = location;
        this.averageEstimatedKeysPerSSTable = Math.round(((double)this.averageEstimatedKeysPerSSTable * (double)this.sstablesWritten + (double)this.partitionsWritten) / (double)(this.sstablesWritten + 1));
        this.sstableWriter.switchWriter(SSTableWriter.create(Descriptor.fromFilename(this.cfs.getSSTablePath(this.getDirectories().getLocationForDisk(this.sstableDirectory))), this.keysPerSSTable, (Long)this.minRepairedAt, this.cfs.metadata, new MetadataCollector(this.txn.originals(), this.cfs.metadata.comparator, this.currentLevel), SerializationHeader.make(this.cfs.metadata, this.txn.originals()), this.cfs.indexManager.listIndexes(), (LifecycleNewTracker)this.txn));
        this.partitionsWritten = 0L;
        this.sstablesWritten = 0;
    }
}

