/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowsTimer {
    private static final Logger logger = LoggerFactory.getLogger(WindowsTimer.class);
    private static boolean available;

    private static native int timeBeginPeriod(int var0) throws LastErrorException;

    private static native int timeEndPeriod(int var0) throws LastErrorException;

    private WindowsTimer() {
    }

    public static void startTimerPeriod(int period) {
        if (period == 0) {
            return;
        }
        assert (period > 0);
        if (!available) {
            return;
        }
        if (WindowsTimer.timeBeginPeriod(period) != 0) {
            logger.warn("Failed to set timer to : {}. Performance will be degraded.", (Object)period);
        }
    }

    public static void endTimerPeriod(int period) {
        if (period == 0) {
            return;
        }
        assert (period > 0);
        if (!available) {
            return;
        }
        if (WindowsTimer.timeEndPeriod(period) != 0) {
            logger.warn("Failed to end accelerated timer period. System timer will remain set to: {} ms.", (Object)period);
        }
    }

    static {
        try {
            Native.register((String)"winmm");
            available = true;
        }
        catch (NoClassDefFoundError e) {
            logger.warn("JNA not found. winmm.dll cannot be registered. Performance will be negatively impacted on this node.");
        }
        catch (UnsatisfiedLinkError e) {
            logger.error("Failed to link the winmm.dll library against JNA. Performance will be negatively impacted on this node.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Failed to register winmm.dll. Performance will be negatively impacted on this node.");
        }
    }
}

