/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming.messages;

import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.cassandra.io.util.DataOutputStreamPlus;
import org.apache.cassandra.streaming.StreamSession;
import org.apache.cassandra.streaming.messages.CompleteMessage;
import org.apache.cassandra.streaming.messages.IncomingFileMessage;
import org.apache.cassandra.streaming.messages.KeepAliveMessage;
import org.apache.cassandra.streaming.messages.OutgoingFileMessage;
import org.apache.cassandra.streaming.messages.PrepareMessage;
import org.apache.cassandra.streaming.messages.ReceivedMessage;
import org.apache.cassandra.streaming.messages.RetryMessage;
import org.apache.cassandra.streaming.messages.SessionFailedMessage;

public abstract class StreamMessage {
    public static final int VERSION_20 = 2;
    public static final int VERSION_22 = 3;
    public static final int VERSION_30 = 4;
    public static final int CURRENT_VERSION = 4;
    private volatile transient boolean sent = false;
    public final Type type;

    public static void serialize(StreamMessage message, DataOutputStreamPlus out, int version, StreamSession session) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate(1);
        buff.put(message.type.type);
        buff.flip();
        out.write(buff);
        message.type.outSerializer.serialize(message, out, version, session);
    }

    public static StreamMessage deserialize(ReadableByteChannel in, int version, StreamSession session) throws IOException {
        ByteBuffer buff = ByteBuffer.allocate(1);
        int readBytes = in.read(buff);
        if (readBytes > 0) {
            buff.flip();
            Type type = Type.get(buff.get());
            return type.inSerializer.deserialize(in, version, session);
        }
        if (readBytes == 0) {
            return null;
        }
        throw new SocketException("End-of-stream reached");
    }

    public void sent() {
        this.sent = true;
    }

    public boolean wasSent() {
        return this.sent;
    }

    protected StreamMessage(Type type) {
        this.type = type;
    }

    public int getPriority() {
        return this.type.priority;
    }

    public static enum Type {
        PREPARE(1, 5, PrepareMessage.serializer),
        FILE(2, 0, IncomingFileMessage.serializer, OutgoingFileMessage.serializer),
        RECEIVED(3, 4, ReceivedMessage.serializer),
        RETRY(4, 4, RetryMessage.serializer),
        COMPLETE(5, 1, CompleteMessage.serializer),
        SESSION_FAILED(6, 5, SessionFailedMessage.serializer),
        KEEP_ALIVE(7, 5, KeepAliveMessage.serializer);

        private final byte type;
        public final int priority;
        public final Serializer<StreamMessage> inSerializer;
        public final Serializer<StreamMessage> outSerializer;

        public static Type get(byte type) {
            for (Type t : Type.values()) {
                if (t.type != type) continue;
                return t;
            }
            throw new IllegalArgumentException("Unknown type " + type);
        }

        private Type(int type, int priority, Serializer serializer) {
            this(type, priority, serializer, serializer);
        }

        private Type(int type, int priority, Serializer inSerializer, Serializer outSerializer) {
            this.type = (byte)type;
            this.priority = priority;
            this.inSerializer = inSerializer;
            this.outSerializer = outSerializer;
        }
    }

    public static interface Serializer<V extends StreamMessage> {
        public V deserialize(ReadableByteChannel var1, int var2, StreamSession var3) throws IOException;

        public void serialize(V var1, DataOutputStreamPlus var2, int var3, StreamSession var4) throws IOException;
    }
}

