/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.RebufferingInputStream;

public class DataInputBuffer
extends RebufferingInputStream {
    private static ByteBuffer slice(byte[] buffer, int offset, int length) {
        ByteBuffer buf = ByteBuffer.wrap(buffer);
        if (offset > 0 || length < buf.capacity()) {
            buf.position(offset);
            buf.limit(offset + length);
            buf = buf.slice();
        }
        return buf;
    }

    public DataInputBuffer(ByteBuffer buffer, boolean duplicate) {
        super(duplicate ? buffer.duplicate() : buffer);
    }

    public DataInputBuffer(byte[] buffer, int offset, int length) {
        super(DataInputBuffer.slice(buffer, offset, length));
    }

    public DataInputBuffer(byte[] buffer) {
        super(ByteBuffer.wrap(buffer));
    }

    @Override
    protected void reBuffer() {
    }

    @Override
    public int available() {
        return this.buffer.remaining();
    }

    @Override
    public void close() {
    }
}

