/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.SimpleDateType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TimestampType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimeFcts {
    public static Logger logger = LoggerFactory.getLogger(TimeFcts.class);
    public static final Function nowFct = new NativeScalarFunction("now", (AbstractType)TimeUUIDType.instance, new AbstractType[0]){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            return ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes());
        }
    };
    public static final Function minTimeuuidFct = new NativeScalarFunction("mintimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.minTimeUUID(((Date)TimestampType.instance.compose(bb)).getTime())));
        }
    };
    public static final Function maxTimeuuidFct = new NativeScalarFunction("maxtimeuuid", (AbstractType)TimeUUIDType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBuffer.wrap(UUIDGen.decompose(UUIDGen.maxTimeUUID(((Date)TimestampType.instance.compose(bb)).getTime())));
        }
    };
    public static final Function dateOfFct = new NativeScalarFunction("dateof", (AbstractType)TimestampType.instance, new AbstractType[]{TimeUUIDType.instance}){
        private volatile boolean hasLoggedDeprecationWarning;

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb;
            if (!this.hasLoggedDeprecationWarning) {
                this.hasLoggedDeprecationWarning = true;
                logger.warn("The function 'dateof' is deprecated. Use the function 'toTimestamp' instead.");
            }
            if ((bb = parameters.get(0)) == null) {
                return null;
            }
            long timeInMillis = UUIDGen.unixTimestamp(UUIDGen.getUUID(bb));
            return ByteBufferUtil.bytes(timeInMillis);
        }
    };
    public static final Function unixTimestampOfFct = new NativeScalarFunction("unixtimestampof", (AbstractType)LongType.instance, new AbstractType[]{TimeUUIDType.instance}){
        private volatile boolean hasLoggedDeprecationWarning;

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb;
            if (!this.hasLoggedDeprecationWarning) {
                this.hasLoggedDeprecationWarning = true;
                logger.warn("The function 'unixtimestampof' is deprecated. Use the function 'toUnixTimestamp' instead.");
            }
            if ((bb = parameters.get(0)) == null) {
                return null;
            }
            return ByteBufferUtil.bytes(UUIDGen.unixTimestamp(UUIDGen.getUUID(bb)));
        }
    };
    public static final Function timeUuidtoDate = new NativeScalarFunction("todate", (AbstractType)SimpleDateType.instance, new AbstractType[]{TimeUUIDType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            long timeInMillis = UUIDGen.unixTimestamp(UUIDGen.getUUID(bb));
            return SimpleDateType.instance.fromTimeInMillis(timeInMillis);
        }
    };
    public static final Function timeUuidToTimestamp = new NativeScalarFunction("totimestamp", (AbstractType)TimestampType.instance, new AbstractType[]{TimeUUIDType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            long timeInMillis = UUIDGen.unixTimestamp(UUIDGen.getUUID(bb));
            return TimestampType.instance.fromTimeInMillis(timeInMillis);
        }
    };
    public static final Function timeUuidToUnixTimestamp = new NativeScalarFunction("tounixtimestamp", (AbstractType)LongType.instance, new AbstractType[]{TimeUUIDType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBufferUtil.bytes(UUIDGen.unixTimestamp(UUIDGen.getUUID(bb)));
        }
    };
    public static final Function timestampToUnixTimestamp = new NativeScalarFunction("tounixtimestamp", (AbstractType)LongType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            Date date = (Date)TimestampType.instance.compose(bb);
            return date == null ? null : ByteBufferUtil.bytes(date.getTime());
        }
    };
    public static final Function timestampToDate = new NativeScalarFunction("todate", (AbstractType)SimpleDateType.instance, new AbstractType[]{TimestampType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            Date date = (Date)TimestampType.instance.compose(bb);
            return date == null ? null : SimpleDateType.instance.fromTimeInMillis(date.getTime());
        }
    };
    public static final Function dateToTimestamp = new NativeScalarFunction("totimestamp", (AbstractType)TimestampType.instance, new AbstractType[]{SimpleDateType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            long millis = SimpleDateType.instance.toTimeInMillis(bb);
            return TimestampType.instance.fromTimeInMillis(millis);
        }
    };
    public static final Function dateToUnixTimestamp = new NativeScalarFunction("tounixtimestamp", (AbstractType)LongType.instance, new AbstractType[]{SimpleDateType.instance}){

        @Override
        public ByteBuffer execute(int protocolVersion, List<ByteBuffer> parameters) {
            ByteBuffer bb = parameters.get(0);
            if (bb == null) {
                return null;
            }
            return ByteBufferUtil.bytes(SimpleDateType.instance.toTimeInMillis(bb));
        }
    };
}

